/********************************  ZW_Portable.h  ********************************
 *           #######
 *           ##  ##
 *           #  ##    ####   #####    #####  ##  ##   #####
 *             ##    ##  ##  ##  ##  ##      ##  ##  ##
 *            ##  #  ######  ##  ##   ####   ##  ##   ####
 *           ##  ##  ##      ##  ##      ##   #####      ##
 *          #######   ####   ##  ##  #####       ##  #####
 *                                           #####
 *          Z-Wave, the wireless language.
 *
 *              Copyright (c) 2001
 *              Zensys A/S
 *              Denmark
 *
 *              All Rights Reserved
 *
 *    This source file is subject to the terms and conditions of the
 *    Zensys Software License Agreement which restricts the manner
 *    in which it may be used.
 *
 *---------------------------------------------------------------------------
 * Copyright Zensys A/S, 2001
 *
 * Description: Include file for Portable controller
 *
 * Author:   Oleg Zadorozhnyy
 *
 * 2007-08-11   OZA     Integrated with Z-Wave Used with iccAVR
 *
 * Last Changed By:  $Author: oza $
 * Revision:         $Revision: 1.17 $
 * Last Changed:     $Date: 2009/02/20 12:39:20 $
 *
 ****************************************************************************/
#ifndef _PORTABLE_H_
#define _PORTABLE_H_

#define PORTABLE_CTRL_VERSION    1
#define PORTABLE_CTRL_REVISION   29

#define DEFAULT_SUC_NODE_ID  0x00
/* Size of Report (ALL/LOCK/MULTI/BASIC GET response) frame payload */
#define REPORTSIZE                            3

/* Report command definition - ALL/LOCK/MULTI report use the same value ;-) */
#define REPORT_CMD                            SWITCH_MULTILEVEL_REPORT

/*Commands for the ControlGroup function*/
#define TOGGLE    0x01
#define DIM_START 0x02
#define DIM_STOP  0x03
#define DIM_SET   0x04

/*Defines and macros used to update the groupState variable*/
#define GROUP_ON_BIT        0x80
#define GROUP_DIR_BIT       0x40

/* How many classes do we belong to */
#define CLASS_MEMBERSHIP_COUNT  3

typedef struct s_nodeInfo_
{
   BYTE memberClass[CLASS_MEMBERSHIP_COUNT];  /* Command class membership */
} t_nodeInfo;

typedef struct s_nodeStatus_ {
   BYTE status;     /* Dimmer status  */
   BYTE level;      /* Dimmer light level   */
} t_nodeStatus;

/*timeouts*/
#define BUSY_BLINK_RATE   20 /2 /* (10ms ticks) Blinking rate during busy states*/
#define ADD_TO_GROUP_RATE 10 /2 /* (10ms ticks) Blinking rate during dimming and node/s added to group */
#define DIM_END_TIMEOUT   200/2 /* (10ms ticks) Wait before assuming that dim set is done */
#define RESET_TIMEOUT     200/2 /* (10ms ticks) Wait before resetting the controller */
#define LED0_ONTIME       50 /2 /* (10ms ticks) Keep LED0 on for this time after command completed */
#define REPL_TIMEOUT      200/2	/* (10ms ticks) Replication timeout - wait for this time period before aborting replication */

/* Binary Switch definitions */
#define SWITCHED_ON                                     0xFF/*01;*/
#define SWITCHED_OFF                                    0x00

#define LED0_OFF LED_OFF(1)
#define LED1_OFF LED_OFF(2)
#define LED0_ON  LED_ON(1)
#define LED1_ON  LED_ON(2)
/* Offsets into frame received */
#define OFFSET_CLASSCMD                       0x00
#define OFFSET_CMD                            0x01
#define OFFSET_PARAM_1                        0x02
#define OFFSET_PARAM_2                        0x03
#define OFFSET_PARAM_3                        0x04
#define OFFSET_PARAM_4                        0x05
/*==========================   ZW_NodeMaskNodeIn   ==========================
**    Check if a node is in a nodemask
**
** BYTE       RET   ZERO if not in nodemask, NONEZERO if in nodemask
** ZW_NodeMaskNodeIn(
** BYTE_P pMask,     IN   pointer to nodemask to check for bNode
** BYTE bNode);      IN   bit number that should be checked
**--------------------------------------------------------------------------*/
#define ZW_NODE_MASK_NODE_IN(pMask, bNode) ZW_NodeMaskNodeIn(pMask, bNode)

/*===========================   ZW_NodeMaskClear   ==========================
**    Clear all bits in a nodemask
**
** void       RET   Nothing
** ZW_NodeMaskClear(
** BYTE_P pMask,     IN   nodemask
** BYTE bLength);    IN   length of nodemask
**--------------------------------------------------------------------------*/
#define ZW_NODE_MASK_CLEAR(pMask, bLength) ZW_NodeMaskClear(pMask, bLength)

#endif /* _PORTABLE_H_ */

