/*******************************  DEV_CTRL_IF.H  *******************************
 *           #######
 *           ##  ##
 *           #  ##    ####   #####    #####  ##  ##   #####
 *             ##    ##  ##  ##  ##  ##      ##  ##  ##
 *            ##  #  ######  ##  ##   ####   ##  ##   ####
 *           ##  ##  ##      ##  ##      ##   #####      ##
 *          #######   ####   ##  ##  #####       ##  #####
 *                                           #####
 *          Z-Wave, the wireless lauguage.
 *
 *              Copyright (c) 2001
 *              Zensys A/S
 *              Denmark
 *
 *              All Rights Reserved
 *
 *    This source file is subject to the terms and conditions of the
 *    Zensys Software License Agreement which restricts the manner
 *    in which it may be used.
 *
 *---------------------------------------------------------------------------
 *
 * Description: IO definitions for the Z-Wave Generic development board
 *
 * Author:   Henrik Holm
 *
 * Last Changed By:  $Author: efh $
 * Revision:         $Revision: 22531 $
 * Last Changed:     $Date: 2012-03-20 16:19:42 +0100 (Tue, 20 Mar 2012) $
 *
 ****************************************************************************/
#ifndef _DEV_CTRL_IF_H_
#define _DEV_CTRL_IF_H_

/****************************************************************************/
/*                              INCLUDE FILES                               */
/****************************************************************************/
#include <ZW_pindefs.h>

/****************************************************************************/
/*                     EXPORTED TYPES and DEFINITIONS                       */
/****************************************************************************/

/* Push button pins */

#define PB0Port  ZEROXpinPort
#define PB0DDR   ZEROXpinDDR
#define PB0PULL  ZEROXpinPULL
#define PB0      ZEROXpin

#define PB1Port  TRIACpinPort
#define PB1DDR   TRIACpinDDR
#define PB1PULL  TRIACpinPULL
#define PB1      TRIACpin

#define PB2Port  MISOPort
#define PB2DDR   MISODDR
#define PB2PULL  MISOPULL
#define PB2      MISO

#define PB3Port  MOSIPort
#define PB3DDR   MOSIDDR
#define PB3PULL  MOSIPULL
#define PB3      MOSI

#define PB4Port  TXDpinPort
#define PB4DDR   TXDpinDDR
#define PB4PULL  TXDpinPULL
#define PB4      TXDpin

#if defined(ZW020x) || defined(ZW030x)

#define LED0Port PWMPort
#define LED0DDR  PWMDDR
#define LED0Pin  PWMPin
#define LED0     PWM
#define LED0PULL PWMPULL

#define LED1Port RXDpinPort
#define LED1DDR  RXDpinDDR
#define LED1Pin  RXDpinPin
#define LED1     RXDpin
#define LED1PULL RXDpinPULL

#define EEPCSPort SSNPort
#define EEPCSDDR  SSNDDR
#define EEPCSPin  SSNPin
#define EEPCS     SSN

#endif
#endif /* __H_ */
