/******************************  CONHANDLE.H  *******************************
 *           #######
 *           ##  ##
 *           #  ##    ####   #####    #####  ##  ##   #####
 *             ##    ##  ##  ##  ##  ##      ##  ##  ##
 *            ##  #  ######  ##  ##   ####   ##  ##   ####
 *           ##  ##  ##      ##  ##      ##   #####      ##
 *          #######   ####   ##  ##  #####       ##  #####
 *                                           #####
 *          Z-Wave, the wireless language.
 *
 *              Copyright (c) 2001
 *              Zensys A/S
 *              Denmark
 *
 *              All Rights Reserved
 *
 *    This source file is subject to the terms and conditions of the
 *    Zensys Software License Agreement which restricts the manner
 *    in which it may be used.
 *
 *---------------------------------------------------------------------------
 *
 * Description:     Header file for conhandle module
 *
 * Author:          Kim Jakobsen
 *
 * Last Changed By:  $Author: efh $
 * Revision:         $Revision: 22519 $
 * Last Changed:     $Date: 2012-03-20 15:51:27 +0100 (Tue, 20 Mar 2012) $
 *
 ****************************************************************************/
#ifndef _CONHANDLE_H_
#define _CONHANDLE_H_

/****************************************************************************/
/*                              INCLUDE FILES                               */
/****************************************************************************/


/****************************************************************************/
/*                     EXPORTED TYPES and DEFINITIONS                       */
/****************************************************************************/
/* return values for ConUpdate */
enum T_CON_TYPE
{
  conIdle,            // returned if nothing special has happened
  conFrameReceived,   // returned when a valid frame has been received
  conFrameSent,       // returned if frame was ACKed by the other end
  conFrameErr,        // returned if frame has error in Checksum
  conRxTimeout,       // returned if Rx timeout has happened
  conTxTimeout        // returned if Tx timeout (waiting for ACK) ahs happened
};

/* defines for accessing serial protocol data */
#define serFrameLen (*serBuf)
#define serFrameType (*(serBuf + 1))
#define serFrameCmd (*(serBuf + 2))
#define serFrameDataPtr (serBuf + 3)

/****************************************************************************/
/*                              EXPORTED DATA                               */
/****************************************************************************/
/* serial buffer size */
#define SERBUF_MAX  74
#define FRAME_LENGTH_MIN  3
#define FRAME_LENGTH_MAX  SERBUF_MAX

/* Serial timeout definitions - These can be changed to fit the requirements present */
/* Either timeout definition should never be set lower than 2 (20ms) */

/* ACK Timeout is 1500 ms to allow HOST system to react - module transmits and waits */
/* max 1500ms before either starting a retransmit or simply drops the frame */
#define RX_ACK_TIMEOUT_DEFAULT  150
/* Receive byte inframe timeout is 150 ms to allow for byte not being fetched */
/* "instantaneously" from receive buffer after physically being buffered by the */
/* interrupt routine - this also includes HOST system byte transmit delays */
#define RX_BYTE_TIMEOUT_DEFAULT 15


#if defined(ZW020x) || defined(ZW030x)
extern IBYTE timeOutRX_ACK;
extern IBYTE timeOutRX_BYTE;
#else
extern PBYTE timeOutRX_ACK;
extern PBYTE timeOutRX_BYTE;
#endif
extern PBYTE serBuf[SERBUF_MAX];
extern IBYTE serBufLen;


/****************************************************************************/
/*                           EXPORTED FUNCTIONS                             */
/****************************************************************************/

/*===============================   ConTxFrame   =============================
**
**   Transmit frame via serial port by adding SOF, Len, Type, cmd and Chksum.
**   Frame  : SOF-Len-Type-Cmd-DATA-Chksum
**    where SOF is Start of frame byte
**          Len is length of bytes between and including Len to last DATA byte
**          Type is Response or Request
**          Cmd Serial application command describing what DATA is
**          DATA as it says
**          Chksum is a XOR checksum taken on all BYTEs from Len to last DATA byte
**
**          NOTE: If Buf is NULL then the previously used cmd, type, Buf and len
**          is used again (Retransmission)
**
**--------------------------------------------------------------------------*/
extern void   /*RET Nothing */
ConTxFrame(
  BYTE cmd,   /* IN Command */
  BYTE type,  /* IN frame Type to send (Response or Request) */
  XBYTE *Buf, /* IN pointer to BYTE buffer containing DATA to send */
  BYTE len);  /* IN the length of DATA to transmit */

/*==============================   ConUpdate   =============================
**
**   Parses serial data sent from external controller module (PC-controller).
**   Should be frequently called by main loop.
**
**   Return: conIdle          if nothing has happened
**           conFrameReceived if valid frame was received
**           conFrameSent     if transmitted frame was ACKed by other end
**           conFrameErr      if received frame has error in Checksum
**           conRxTimeout     if a Rx timeout happened
**           conTxTimeout     if a Tx timeout waiting for ACK happened
**
**--------------------------------------------------------------------------*/
extern enum T_CON_TYPE  /*RET conState (See above) */
ConUpdate(
  BOOL acknowledge);    /* IN Nothing */

/*==============================   ConInit   =============================
**
**   Initialize the module.
**
**--------------------------------------------------------------------------*/
void                /*RET  Nothing */
ConInit(void);       /*IN   Nothing */

#endif /* _CONHANDLE_H_ */
