/********************************  prodtestdut.c  *****************************
 *           #######
 *           ##  ##
 *           #  ##    ####   #####    #####  ##  ##   #####
 *             ##    ##  ##  ##  ##  ##      ##  ##  ##
 *            ##  #  ######  ##  ##   ####   ##  ##   ####
 *           ##  ##  ##      ##  ##      ##   #####      ##
 *          #######   ####   ##  ##  #####       ##  #####
 *                                           #####
 *          Z-Wave, the wireless language.
 *
 *              Copyright (c) 2001
 *              Zensys A/S
 *              Denmark
 *
 *              All Rights Reserved
 *
 *    This source file is subject to the terms and conditions of the
 *    Zensys Software License Agreement which restricts the manner
 *    in which it may be used.
 *
 *---------------------------------------------------------------------------
 * Copyright Zensys A/S, 2001
 *
 * Description: Application used in productiontest
 *
 * Author:   Henrik Holm
 *
 * Last Changed By:  $Author: efh $
 * Revision:         $Revision: 22546 $
 * Last Changed:     $Date: 2012-03-20 16:26:09 +0100 (Tue, 20 Mar 2012) $
 *
 ****************************************************************************/

/****************************************************************************/
/*                              INCLUDE FILES                               */
/****************************************************************************/
#include <config_app.h>
#include <ZW_basis_api.h>
#include <ZW_slave_api.h>
#include <ZW_pindefs.h>
#ifdef ENABLE_DEBUG_LEDS
#include <ZW_evaldefs.h>
#endif
#include <prodtestdut.h>



/****************************************************************************/
/*                      PRIVATE TYPES and DEFINITIONS                       */
/****************************************************************************/
#ifdef ZW010x
#ifdef SFF
/* IO10 pin now input */
#define SET_PRODUCTIONTEST_PIN  PIN_IN(IO10, 0)
#define IN_PRODUCTIONTEST       (!PIN_GET(IO10))
#else
/* IO10 pin now input */
#define SET_PRODUCTIONTEST_PIN  PIN_IN(ZEROXpin, 0)
#define IN_PRODUCTIONTEST       PIN_GET(ZEROXpin)
#endif
#endif /*ZW010x*/
#ifdef ZW020x
/* SSNJ pin now input */
#define SET_PRODUCTIONTEST_PIN  PIN_IN(SSN, 0)
#define IN_PRODUCTIONTEST       (!PIN_GET(SSN))
#endif /*ZW020x*/
#ifdef ZW030x
/* SSNJ pin now input */
#define SET_PRODUCTIONTEST_PIN  PIN_IN(SSN, 0)
#define IN_PRODUCTIONTEST       (!PIN_GET(SSN))
#endif /*ZW030x*/

/****************************************************************************/
/*                              PRIVATE DATA                                */
/****************************************************************************/
BOOL  testMode = FALSE;
/****************************************************************************/
/*                              EXPORTED DATA                               */
/****************************************************************************/

/****************************************************************************/
/*                            PRIVATE FUNCTIONS                             */
/****************************************************************************/

/****************************************************************************/
/*                           EXPORTED FUNCTIONS                             */
/****************************************************************************/

/*============================   ApplicationInitHW   ========================
**    Initialization of non Z-Wave module hardware
**
**    Side effects:
**       Returning FALSE from this function will force the API into
**       production test mode.
**--------------------------------------------------------------------------*/
#ifdef ZW010x
BYTE                       /*RET  TRUE        */
ApplicationInitHW( void )  /* IN  Nothing     */
#else
BYTE
ApplicationInitHW(
  BYTE bWakeupReason       /* Reason for the powerup of the chip */
)
#endif /* *ZW010x */
{
  IBYTE i;
#ifdef ENABLE_DEBUG_LEDS
  PIN_OUT(LED1);
  PIN_OUT(LED2);
  PIN_OUT(LED3);
  LED_OFF(1);
  LED_OFF(2);
  LED_OFF(3);
#endif
  SET_PRODUCTIONTEST_PIN;
  for (i = 0; i < 10; i++) ;  /* Short delay... */
  if (IN_PRODUCTIONTEST) /* Anyone forcing it into productiontest mode ? */
  {
  	testMode = TRUE;
#ifdef ENABLE_DEBUG_LEDS
    LED_ON(2);
#endif
    return(FALSE);  /*Enter production test mode*/
  }
  else
  {
  	testMode = FALSE;
  }
#ifdef ENABLE_DEBUG_LEDS
  LED_OFF(2);
  LED_ON(1);
#endif

  return(TRUE);
}


#define P1_AVOID_MASK    0xC3 /*1100 0011*/
#define P0_AVOID_MASK    0x03 /*0000 0011*/
/*============================   ApplicationTestPoll   ======================
**    Function description
**      This function is called when the slave enters test mode.
**
**    Side effects:
**       Code will not exit until it is reset
**--------------------------------------------------------------------------*/
void ApplicationPoll(void)
{
	if(testMode)
	{
    /*Send constant out*/
#if defined(ZW020x) || defined(ZW030x)
    WORD lowDelay = 6400; //Minimum 200uS.. We say 6400
    BOOL checkFailed = FALSE;
    PIN_OUT(INT1pin);
    PIN_OUT(INT0pin);
    PIN_OUT(RXDpin);
    PIN_OUT(TXDpin);
    PIN_OUT(ZEROXpin);
    PIN_OUT(TRIACpin);
  //P0DIR = all outputs
  //P1DIR = P1.7, P1.6, P1.1, P1.0 outputs
    P0DIR = 0x00;
    P1DIR &= 0x3C;

    P0 = 0;
    P1 &= 0x3C;   // set ports low
    P0 = 0x03;    // set ports high
    P1 |= 0xC3;
    P0 = 0;       // set ports low
    P1 &= 0x3C;


    P0 |= 0x02;	// P00 low, P01 high
    P1 |= 0x42;	// P1.6 and P1.1 high, rest of port low or input
    /*Test with 0xAA*/
  //  P1 |= (0xAA&P1_AVOID_MASK);
  //  P0 = 0xAA;
    if (P0 != 0x02)
    {
      checkFailed = TRUE;
    }

    if ((P1 & 0xC3) != 0x42)
    {
      checkFailed = TRUE;
    }

    P0 &= ~0x02;	// reset port
    P1 &= ~0x42;	// reset port

    P0 |= 0x01;	// P00 high, P01 low
    P1 |= 0x81;	// P10 high and P1.7 high, rest low

    if (P0 != 0x01)
    {
      checkFailed = TRUE;
    }

    if ((P1 & 0xC3) != 0x81)
    {
      checkFailed = TRUE;
    }

    P0 |= 0x03;	// set P00 and P01 high
    P1 |= 0xC3;	// set P1.7, P1.6, P1.1 and P1.0 high

    if (P0 != 0x03)
    {
      checkFailed = TRUE;
    }

    if (P1 & 0xC3 != 0xC3)
    {
      checkFailed = TRUE;
    }
    P0DIR = 0xFF;
  //P1DIR = P1.7, P1.6, P1.1, P1.0 inputs
    P1DIR |= 0xC3;

    P0PULLUP = 0x00; //Enable on P00 and P01
    P1PULLUP &= 0x3C; //Enable on P1.7, P1.6, P1.1 and P1.0

    while(lowDelay--); //Delay so pins can settle

    if (P0 != 0x00)
    {
      checkFailed = TRUE;
    }

    if (P1 & 0xC3 != 0x00)
    {
      checkFailed = TRUE;
    }

#endif /*ZW020x || ZW030x*/
#ifdef ENABLE_DEBUG_LEDS
    LED_ON(1);
    LED_ON(2);
    LED_ON(3);
#endif
#if defined(ZW020x) || defined(ZW030x)
    if(checkFailed)
    {
      while(1);
    }
#endif
    ZW_SEND_CONST();
    while(1);
  }

}
