using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.Devices;
using OpenSource.UPnP.AV;

namespace Zensys.ZWave.UPnPBridge.UPnPClasses
{
    public class BridgedDevice: IComparable<BridgedDevice>, IEquatable<BridgedDevice>
    {
        public BridgedDevice(IDeviceInfo zWaveDevice, ZWaveUPnPDevice uPnPDevice)
        {
            mZWaveDevice = zWaveDevice;
            mUPnPDevice = uPnPDevice;
        }

        private ZWaveUPnPDevice mUPnPDevice;
        public ZWaveUPnPDevice UPnPDevice
        {
            get { return mUPnPDevice; }
            set { mUPnPDevice = value; }
        }
        private IDeviceInfo mZWaveDevice;
        public IDeviceInfo ZWaveDevice
        {
            get { return mZWaveDevice; }
            set { mZWaveDevice = value; }
        }

        public byte Id
        {
            get { return mZWaveDevice.Id; }
        }

        public string Type
        {
            get { return mZWaveDevice.Type; }
        }

        public string FriendlyName
        {
            get { return mUPnPDevice.FriendlyName; }
        }

        #region IEquatable<BridgedDevice> Members

        public bool Equals(BridgedDevice other)
        {
            if (Id == other.Id)
            {
                return true;
            }
            else
            {
                return false;
            }
        }

        #endregion

        #region IComparable<BridgedDevice> Members

        public int CompareTo(BridgedDevice other)
        {
            if (Id < other.Id)
            {
                return -1;
            }
            else if (Id > other.Id)
            {
                return 1;
            }
            else
            {
                return 0;
            }
        }

        #endregion

        internal void SwitchUPnPDevice(byte value)
        {
            if (UPnPDevice is ZWaveUPnPBinaryLightDevice)
            {
                ZWaveUPnPBinaryLightDevice deviceBL = (ZWaveUPnPBinaryLightDevice)UPnPDevice;
                deviceBL.SetTarget(value != 0);
            }
            else if (UPnPDevice is ZWaveUPnPMediaRendererDevice)
            {
                ZWaveUPnPMediaRendererDevice deviceMR = (ZWaveUPnPMediaRendererDevice)UPnPDevice;
                if (value != 0)
                {
                    deviceMR.AVTransport.Play(0, CpAVTransport.Enum_TransportPlaySpeed._1);
                }
                else
                {
                    deviceMR.AVTransport.Stop(0);
                }
            }
        }
    }
}
