using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.UPnPBridge.Classes;
using Zensys.ZWave.UPnPBridge.Models;

namespace Zensys.ZWave.UPnPBridge.Interfaces
{
    public interface IViewDispatcher
    {
        /// <summary>
        /// Binds the specified view.
        /// </summary>
        /// <param name="view">The view.</param>
        /// <param name="actions">The actions.</param>
        void Bind(IView view, ActionCollection actions, DocumentModel documentModel);
        /// <summary>
        /// Drops the specified view.
        /// </summary>
        /// <param name="view">The view.</param>
        /// <param name="actions">The actions.</param>
        void Drop(IView view, ActionCollection actions, DocumentModel documentModel);
    }
}
