using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.UPnPBridge.Classes;
using Zensys.ZWave.UPnPBridge.Controllers;
using Zensys.ZWave.UPnPBridge.Interfaces;
using Zensys.ZWave.UPnPBridge.UI;
using System.Windows.Forms;

namespace Zensys.ZWave.UPnPBridge.Dispatchers
{
    public class UPnPRendererCPDispatcher : IViewDispatcher
    {
        #region IViewDispatcher Members
        public void Bind(IView view, ActionCollection actions, Zensys.ZWave.UPnPBridge.Models.DocumentModel documentModel)
        {
            UPnPRendererCPForm form = (UPnPRendererCPForm)view;
            //Form
            form.Load += actions.UPnPRendererCPActions.OnFormLoad;
            form.FormClosing += actions.UPnPRendererCPActions.OnFormClosing;
            form.ButtonReScan.Click += actions.UPnPRendererCPActions.OnButtonReScanClick;
            form.ButtonPlay.Click += actions.UPnPRendererCPActions.OnButtonPlayClick;
            form.ButtonPause.Click += actions.UPnPRendererCPActions.OnButtonPauseClick;
            form.ButtonStop.Click += actions.UPnPRendererCPActions.OnButtonStopClick;
            form.ButtonPrev.Click += actions.UPnPRendererCPActions.OnButtonPrevClick;
            form.ButtonNext.Click += actions.UPnPRendererCPActions.OnButtonNextClick;
        }

        public void Drop(IView view, ActionCollection actions, Zensys.ZWave.UPnPBridge.Models.DocumentModel documentModel)
        {
            UPnPRendererCPForm form = (UPnPRendererCPForm)view;
            //Form
            form.Load -= actions.UPnPRendererCPActions.OnFormLoad;
            form.FormClosing -= actions.UPnPRendererCPActions.OnFormClosing;
            form.ButtonReScan.Click -= actions.UPnPRendererCPActions.OnButtonReScanClick;
            form.ButtonPlay.Click -= actions.UPnPRendererCPActions.OnButtonPlayClick;
            form.ButtonPause.Click -= actions.UPnPRendererCPActions.OnButtonPauseClick;
            form.ButtonStop.Click -= actions.UPnPRendererCPActions.OnButtonStopClick;
            form.ButtonPrev.Click -= actions.UPnPRendererCPActions.OnButtonPrevClick;
            form.ButtonNext.Click -= actions.UPnPRendererCPActions.OnButtonNextClick;
        }
        #endregion
    }
}
