using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.UPnPBridge.Interfaces;
using Zensys.ZWave.UPnPBridge.Classes;
using Zensys.ZWave.UPnPBridge.UI;
using Zensys.ZWave.UPnPBridge.Models;
using System.Windows.Forms;

namespace Zensys.ZWave.UPnPBridge.Dispatchers
{
    public class NodeFormDispatcher : IViewDispatcher
    {
        #region IViewDispatcher Members
        public void Bind(IView view, ActionCollection actions, DocumentModel documentModel)
        {
            NodeForm form = (NodeForm)view;
            //Form
            form.Load += new EventHandler(actions.NodeFormActions.OnFormLoad);
            form.FormClosing += new FormClosingEventHandler(actions.NodeFormActions.OnFormClosing);

            form.vcAddNodeNetworkWideToolStripButton.Click += new EventHandler(actions.NodeFormActions.OnNetworkWideInclusionClick);
            form.vcAddNodeToolStripButton.Click += new EventHandler(actions.NodeFormActions.OnAddNodeClick);
            form.vcRemoveNodeToolStripButton.Click += new EventHandler(actions.NodeFormActions.OnRemoveNodeClick);
            form.vcNodeInfoToolStripButton.Click += new EventHandler(actions.NodeFormActions.OnNodeInfoClick);
            form.vcSetOnToolStripButton.Click += new EventHandler(actions.NodeFormActions.OnSetOnClick);
            form.vcSetOffToolStripButton.Click += new EventHandler(actions.NodeFormActions.OnSetOffClick);
            form.vcIsFailedNodeToolStripButton.Click += new EventHandler(actions.NodeFormActions.OnIsFailedNodeClick);
            form.vcReplaceFailedNodeToolStripButton.Click += new EventHandler(actions.NodeFormActions.OnReplaceFailedNodeClick);
            form.vcRemoveFailedNodeToolStripButton.Click += new EventHandler(actions.NodeFormActions.OnRemoveFailedNodeClick);
            form.vcSetAllOnToolStripButton.Click += new EventHandler(actions.NodeFormActions.OnSetAllOnClick);
            form.vcSetAllOffToolStripButton.Click += new EventHandler(actions.NodeFormActions.OnSetAllOffClick);
            form.vcSetWakeUpIntervalToolStripButton.Click += new EventHandler(actions.NodeFormActions.OnSetWakeUpIntervalClick);
            form.vcNopToolStripButton.Click += new EventHandler(actions.NodeFormActions.OnNopToolStripButtonClick);
            form.vcAddVirtualToolStripButton.Click += actions.NodeFormActions.OnAddVirtualClick;
            form.vcRemoveVirtualToolStripButton.Click += actions.NodeFormActions.OnRemoveVirtualClick;
            form.vcTxInfoToolStripButton.Click += actions.NodeFormActions.OnTxInfoClick;
            form.vcTxResetToolStripButton.Click += actions.NodeFormActions.OnTxResetClick;

            documentModel.Devices.ListChanged += new System.ComponentModel.ListChangedEventHandler(actions.NodeFormActions.Devices_ListChanged);
            documentModel.DevicesCurrencyManager.PositionChanged += new EventHandler(actions.NodeFormActions.DevicesCurrencyManager_PositionChanged);
            //DocumentModel
            documentModel.DocumentModelStateChanged += new EventHandler<EventArgs>(actions.NodeFormActions.OnDocumentModelStateChanged);
        }


        public void Drop(IView view, ActionCollection actions, DocumentModel documentModel)
        {
            NodeForm form = (NodeForm)view;
            //Form
            form.Load -= new EventHandler(actions.NodeFormActions.OnFormLoad);
            form.FormClosing -= new FormClosingEventHandler(actions.NodeFormActions.OnFormClosing);

            form.vcAddNodeNetworkWideToolStripButton.Click -= new EventHandler(actions.NodeFormActions.OnNetworkWideInclusionClick);
            form.vcAddNodeToolStripButton.Click -= new EventHandler(actions.NodeFormActions.OnAddNodeClick);
            form.vcRemoveNodeToolStripButton.Click -= new EventHandler(actions.NodeFormActions.OnRemoveNodeClick);
            form.vcNodeInfoToolStripButton.Click -= new EventHandler(actions.NodeFormActions.OnNodeInfoClick);
            form.vcSetOnToolStripButton.Click -= new EventHandler(actions.NodeFormActions.OnSetOnClick);
            form.vcSetOffToolStripButton.Click -= new EventHandler(actions.NodeFormActions.OnSetOffClick);
            form.vcIsFailedNodeToolStripButton.Click -= new EventHandler(actions.NodeFormActions.OnIsFailedNodeClick);
            form.vcReplaceFailedNodeToolStripButton.Click -= new EventHandler(actions.NodeFormActions.OnReplaceFailedNodeClick);
            form.vcRemoveFailedNodeToolStripButton.Click -= new EventHandler(actions.NodeFormActions.OnRemoveFailedNodeClick);
            form.vcSetAllOnToolStripButton.Click -= new EventHandler(actions.NodeFormActions.OnSetAllOnClick);
            form.vcSetAllOffToolStripButton.Click -= new EventHandler(actions.NodeFormActions.OnSetAllOffClick);
            form.vcSetWakeUpIntervalToolStripButton.Click -= new EventHandler(actions.NodeFormActions.OnSetWakeUpIntervalClick);
            form.vcNopToolStripButton.Click -= new EventHandler(actions.NodeFormActions.OnNopToolStripButtonClick);
            form.vcAddVirtualToolStripButton.Click -= actions.NodeFormActions.OnAddVirtualClick;
            form.vcRemoveVirtualToolStripButton.Click -= actions.NodeFormActions.OnRemoveVirtualClick;
            form.vcTxInfoToolStripButton.Click -= actions.NodeFormActions.OnTxInfoClick;
            form.vcTxResetToolStripButton.Click -= actions.NodeFormActions.OnTxResetClick;

            documentModel.Devices.ListChanged -= new System.ComponentModel.ListChangedEventHandler(actions.NodeFormActions.Devices_ListChanged);
            documentModel.DevicesCurrencyManager.PositionChanged -= new EventHandler(actions.NodeFormActions.DevicesCurrencyManager_PositionChanged);
            //DocumentModel
            documentModel.DocumentModelStateChanged -= new EventHandler<EventArgs>(actions.NodeFormActions.OnDocumentModelStateChanged);
        }
        #endregion
    }
}
