using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.UPnPBridge.Interfaces;
using Zensys.ZWave.UPnPBridge.Classes;
using Zensys.ZWave.UPnPBridge.UI;
using Zensys.ZWave.UPnPBridge.Models;

namespace Zensys.ZWave.UPnPBridge.Dispatchers
{
    public class LogFormDispatcher : IViewDispatcher
    {
        #region IViewDispatcher Members
        public void Bind(IView view, ActionCollection actions, DocumentModel documentModel)
        {
            LogForm form = (LogForm)view;
            //Form
            form.Load += actions.LogFormActions.OnFormLoad;
            form.FormClosing += actions.LogFormActions.OnFormClosing;
        }

        public void Drop(IView view, ActionCollection actions, DocumentModel documentModel)
        {
            LogForm form = (LogForm)view;
            //Form
            form.Load -= actions.LogFormActions.OnFormLoad;
            form.FormClosing -= actions.LogFormActions.OnFormClosing;
        }
        #endregion
    }
}
