using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.UPnPBridge.Interfaces;
using Zensys.ZWave.UPnPBridge.Classes;
using Zensys.ZWave.UPnPBridge.Models;
using Zensys.ZWave.UPnPBridge.UI;

namespace Zensys.ZWave.UPnPBridge.Dispatchers
{
    public class CommandClassFormDispatcher : IViewDispatcher
    {
        #region IViewDispatcher Members

        public void Bind(IView view, ActionCollection actions, DocumentModel documentModel)
        {
            CommandClassForm form = (CommandClassForm)view;

            //Form
            form.Load += new EventHandler(actions.CommandClassFormActions.OnFormLoad);
            form.FormClosing += new System.Windows.Forms.FormClosingEventHandler(actions.CommandClassFormActions.OnFormClosing);

            //Controls
            form.vcCommandClassesComboBox.SelectedIndexChanged += new EventHandler(actions.CommandClassFormActions.OnCommandClassesSelectedIndexChanged);
            form.vcCommandNameComboBox.SelectedIndexChanged += new EventHandler(actions.CommandClassFormActions.OnCommandSelectedIndexChanged);

            form.vcSendButton.Click += new EventHandler(actions.CommandClassFormActions.OnCommandSendClick);
            form.vcSendMetaButton.Click += new EventHandler(actions.CommandClassFormActions.OnCommandSendMetaClick);

            //DocumentModel
            documentModel.DocumentModelStateChanged += new EventHandler<EventArgs>(actions.CommandClassFormActions.OnDocumentModelStateChanged);
        }



        public void Drop(IView view, ActionCollection actions, DocumentModel documentModel)
        {
            CommandClassForm form = (CommandClassForm)view;

            //Form
            form.Load -= new EventHandler(actions.CommandClassFormActions.OnFormLoad);
            form.FormClosing -= new System.Windows.Forms.FormClosingEventHandler(actions.CommandClassFormActions.OnFormClosing);

            //Controls
            form.vcCommandClassesComboBox.SelectedIndexChanged -= new EventHandler(actions.CommandClassFormActions.OnCommandClassesSelectedIndexChanged);
            form.vcCommandNameComboBox.SelectedIndexChanged -= new EventHandler(actions.CommandClassFormActions.OnCommandSelectedIndexChanged);

            form.vcSendButton.Click -= new EventHandler(actions.CommandClassFormActions.OnCommandSendClick);
            form.vcSendMetaButton.Click -= new EventHandler(actions.CommandClassFormActions.OnCommandSendMetaClick);

            //DocumentModel
            documentModel.DocumentModelStateChanged -= new EventHandler<EventArgs>(actions.CommandClassFormActions.OnDocumentModelStateChanged);
        }

        #endregion
    }
}
