using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.UPnPBridge.Classes;
using Zensys.ZWave.UPnPBridge.Controllers;
using Zensys.ZWave.UPnPBridge.Interfaces;
using Zensys.ZWave.UPnPBridge.UI;
using System.Windows.Forms;

namespace Zensys.ZWave.UPnPBridge.Dispatchers
{
    public class BridgedUPnPDevicesDispatcher : IViewDispatcher
    {
        #region IViewDispatcher Members
        public void Bind(IView view, ActionCollection actions, Zensys.ZWave.UPnPBridge.Models.DocumentModel documentModel)
        {
            BridgedUPnPDevicesForm form = (BridgedUPnPDevicesForm)view;
            //Form
            form.Load += actions.BridgedUPnPDevicesActions.OnFormLoad;
            form.FormClosing += actions.BridgedUPnPDevicesActions.OnFormClosing;
            form.BridgedUPnPDeviceView.BindDeviceButton.Click += actions.BridgedUPnPDevicesActions.OnBindDeviceClick;
            form.BridgedUPnPDeviceView.BindMediaDeviceButton.Click += actions.BridgedUPnPDevicesActions.OnBindMediaDeviceClick;
            form.BridgedUPnPDeviceView.UnBindDeviceButton.Click += actions.BridgedUPnPDevicesActions.OnUnBindDeviceClick;
        }

        public void Drop(IView view, ActionCollection actions, Zensys.ZWave.UPnPBridge.Models.DocumentModel documentModel)
        {
            BridgedUPnPDevicesForm form = (BridgedUPnPDevicesForm)view;
            //Form
            form.Load += actions.BridgedUPnPDevicesActions.OnFormLoad;
            form.FormClosing -= actions.BridgedUPnPDevicesActions.OnFormClosing;
            form.BridgedUPnPDeviceView.BindDeviceButton.Click -= actions.BridgedUPnPDevicesActions.OnBindDeviceClick;
            form.BridgedUPnPDeviceView.BindMediaDeviceButton.Click -= actions.BridgedUPnPDevicesActions.OnBindMediaDeviceClick;
            form.BridgedUPnPDeviceView.UnBindDeviceButton.Click -= actions.BridgedUPnPDevicesActions.OnUnBindDeviceClick;
        }
        #endregion
    }
}
