using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Collections;
using Zensys.ZWave.Logging;
using Zensys.ZWave.Logging.Events;

namespace Zensys.ZWave.UPnPBridge.Controls
{
    public class TreeDataView : TreeView
    {
        private LogDataSource dataSource;
       
        private void BuildTree()
        {
            lock (this)
            {
                BeginUpdate();
                this.Nodes.Clear();
                foreach (LogSession topRow in dataSource.Sessions)
                {
                    if (topRow.Id != Guid.Empty)
                    {
                        TreeNode topNode = new TreeNode();
                        topNode.Tag = topRow;
                        topNode.Text = topRow.Caption;
                        topNode.ImageIndex = 0;
                        topNode.SelectedImageIndex = 0;
                        Nodes.Add(topNode);
                        AddSubnodes(topNode, topRow);
                    }
                }
                EndUpdate();
            }
        }
        private void AddSessionNode(LogSession session)
        {
            if (session != null && session.Id != Guid.Empty)
            {
                if (session.Parent == null)
                {
                    TreeNode topNode = new TreeNode();
                    topNode.Tag = session;
                    topNode.Text = session.Caption;
                    topNode.ImageIndex = 0;
                    topNode.SelectedImageIndex = 0;
                    Nodes.Add(topNode);
                    AddSubnodes(topNode, session);
                }
                else
                {
                    TreeNode topNode = FindNode(Nodes, session.Parent.Id);
                    if (topNode != null)
                    {
                        TreeNode child = new TreeNode();
                        child.Tag = session;
                        child.Text = session.Caption;
                        child.ImageIndex = 1;
                        child.SelectedImageIndex = 1;
                        topNode.Nodes.Add(child);
                    }
                }
            }
        }
        private void AddSubnodes(TreeNode topNode, LogSession topRow)
        {
           
            foreach (LogSession subRow in topRow.Sessions)
            {
                if (subRow.Id != Guid.Empty)
                {
                    TreeNode subNode = new TreeNode();
                    subNode.Tag = subRow;
                    subNode.Text = subRow.Caption;
                    subNode.ImageIndex = 1;
                    subNode.SelectedImageIndex = 1;
                    topNode.Nodes.Add(subNode);
                    AddSubnodes(subNode, subRow);
                }
            }
        }
        
        public LogSession GetRow(TreeNode treeNode)
        {
            return treeNode.Tag as LogSession;
        }

        private TreeNode FindNode(TreeNodeCollection nodes, Guid UID)
        {
            TreeNode ret = null;
            foreach (TreeNode var in nodes)
            {
                if (GetRow(var).Id == UID)
                {
                    ret = var;
                    break;
                }
                else
                {
                    ret = FindNode(var.Nodes, UID);
                    if (ret != null)
                        break;
                }
            }
            return ret;
        }

        public void SelectNode(Guid UID)
        {
            TreeNode treeNode = FindNode(Nodes, UID);
            if (treeNode != null && treeNode != SelectedNode)
            {
                this.CollapseAll();
                TreeNode expandNode = treeNode;
                while (expandNode.Parent != null)
                {
                    expandNode = expandNode.Parent;
                    expandNode.Expand();
                }
                SelectedNode = treeNode;
            }
        }
        
        [Category("Data")]
        public LogDataSource DataSource
        {
            get
            {
                return dataSource;
            }
            set
            {
                
                if (value != null)
                {
                    dataSource = value;
                    BuildTree();
                    dataSource.SessionDataAdded += new EventHandler<Zensys.ZWave.Logging.Events.SessionDataAddedEventArgs>(dataSource_SessionDataAdded);
                    dataSource.SessionDataCleared += new EventHandler<EventArgs>(dataSource_SessionDataCleared);
                }
            }
        }
        protected override void Dispose(bool disposing)
        {
            base.Dispose(disposing);
            if (dataSource != null)
            {
                dataSource.SessionDataAdded -= new EventHandler<Zensys.ZWave.Logging.Events.SessionDataAddedEventArgs>(dataSource_SessionDataAdded);
                dataSource.SessionDataCleared -= new EventHandler<EventArgs>(dataSource_SessionDataCleared);
            }
        }

        void dataSource_SessionDataAdded(object sender, Zensys.ZWave.Logging.Events.SessionDataAddedEventArgs e)
        {
            if ((sender as LogSession) != null)
            {
                ReAddSessionNode((LogSession)sender, e);
            }
        }

        void dataSource_SessionDataCleared(object sender, EventArgs e)
        {
            ReBuildTree(null);
        }


        protected override void OnAfterSelect(TreeViewEventArgs e)
        {
            base.OnAfterSelect(e);
            dataSource.SelectedSession = GetRow(e.Node);
        }

        private delegate void ReAddSessionNodeDelegate(LogSession sender, SessionDataAddedEventArgs e);
        private void ReAddSessionNode(LogSession sender, SessionDataAddedEventArgs e)
        {
            if (InvokeRequired)
            {
                Invoke(new ReAddSessionNodeDelegate(ReAddSessionNode), new object[] { sender, e });
            }
            else
            {
                AddSessionNode(e.Session);
                if (sender != null)
                {
                    LogSession ls = (LogSession)sender;
                    //SelectNode(ls.Id);
                }
            }
        }

        private delegate void ReBuildTreeDelegate(LogSession sender);
        private void ReBuildTree(LogSession sender)
        {
            if (InvokeRequired)
            {
                Invoke(new ReBuildTreeDelegate(ReBuildTree), new object[] { sender });
            }
            else
            {
                BuildTree();
                if (sender != null)
                {
                    LogSession ls = (LogSession)sender;
                    //SelectNode(ls.Id);
                }
            }
        }
    }
}
