using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.Enums;
using Zensys.ZWave.UPnPBridge.Controllers;
using Zensys.ZWave.ZWaveHAL.Actions;

namespace Zensys.ZWave.UPnPBridge.Classes
{
    public class BaseAction
    {
        private ControllerManager mControllerManager;
        internal ControllerManager ControllerManager
        {
            get { return mControllerManager; }
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="BaseAction"/> class.
        /// </summary>
        /// <param name="controller">The controller.</param>
        public BaseAction(ControllerManager controllerManager)
        {
            mControllerManager = controllerManager;
        }

        public bool IsControllerLibrary(Libraries library)
        {
            return library == Libraries.ControllerBridgeLib;
        }

        private ActionsHAL mActionsHAL;
        public ActionsHAL ActionsHAL
        {
            get { return mActionsHAL; }
            set { mActionsHAL = value; }
        }
	
    }
}
