using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.UPnPBridge.Controllers;
using Zensys.ZWave.ZWaveHAL.Actions;
using Zensys.ZWave.UPnPBridge.Classes;
using System.Windows.Forms;
using Zensys.ZWave.ZWaveHAL;
using Zensys.ZWave.Devices;
using Zensys.ZWave.UPnPBridge.Properties;
using Zensys.ZWave.Enums;
using Zensys.ZWave.Application;

namespace Zensys.ZWave.UPnPBridge.Actions
{
    public class CommandClassFormActions : BaseAction
    {
        public CommandClassViewActions CommandClassHAL;
        public CommandClassFormActions(ControllerManager controller)
            : base(controller)
        {
            CommandClassHAL = CustomLoader.CreateCommandClassViewActionsInstance();
            CommandClassHAL.Initialize(controller.LogManager, controller.ExceptionManager, controller.XmlDataManager);
            CommandClassHAL.AddQueueCommandCallback = controller.AddQueueCommand;
        }

        #region Form
        public void OnFormLoad(object sender, EventArgs e)
        {
            ControllerManager.DocumentModel.DevicesCurrencyManager.ListChanged += DevicesCollection_SelectedDeviceChanged;
            ControllerManager.DocumentModel.DevicesCurrencyManager.CurrentChanged += DevicesCollection_SelectedDeviceChanged;
            ControllerManager.DocumentModel.DevicesCurrencyManager.PositionChanged += DevicesCollection_SelectedDeviceChanged;
            OnDocumentModelStateChanged();
        }


        public void OnFormClosing(object sender, FormClosingEventArgs e)
        {
            ControllerManager.MainForm.CmdClassToolStripMenuItem.Checked = false;
            ControllerManager.CommandClassForm.Hide();
            e.Cancel = true;
        }
        #endregion

        #region DocumentModel
        public void OnDocumentModelStateChanged(object sender, EventArgs e)
        {
            OnDocumentModelStateChanged();
        }
        private delegate void OnDocumentModelStateChangedDelegate();
        private void OnDocumentModelStateChanged()
        {
            if (ControllerManager.CommandClassForm != null && !ControllerManager.CommandClassForm.IsDisposed)
            {

                if (ControllerManager.CommandClassForm.InvokeRequired)
                {
                    ControllerManager.CommandClassForm.Invoke(new OnDocumentModelStateChangedDelegate(OnDocumentModelStateChanged));
                }
                else
                {
                    ControllerManager.CommandClassForm.vcCommandClassesComboBox.Enabled =
                        ControllerManager.DocumentModel.Controller != null &&
                        ControllerManager.DocumentModel.DevicesCurrencyManager.Position > -1;
                    ControllerManager.CommandClassForm.vcCommandNameComboBox.Enabled =
                        ControllerManager.DocumentModel.Controller != null &&
                        ControllerManager.DocumentModel.DevicesCurrencyManager.Position > -1;
                    ControllerManager.CommandClassForm.vcParametersGrid.Enabled =
                        ControllerManager.DocumentModel.Controller != null &&
                        ControllerManager.DocumentModel.DevicesCurrencyManager.Position > -1;
                    ControllerManager.CommandClassForm.vcSendButton.Enabled =
                        ControllerManager.DocumentModel.Controller != null &&
                        ControllerManager.DocumentModel.DevicesCurrencyManager.Position > -1 &&
                        ControllerManager.CommandClassForm.vcCommandClassesComboBox.SelectedItem != null &&
                        ControllerManager.CommandClassForm.vcCommandNameComboBox.SelectedItem != null;
                    ControllerManager.CommandClassForm.vcSendMetaButton.Enabled =
                        ControllerManager.DocumentModel.Controller != null &&
                        ControllerManager.DocumentModel.DevicesCurrencyManager.Position > -1 &&
                        ControllerManager.CommandClassForm.vcCommandClassesComboBox.SelectedItem != null &&
                        ControllerManager.CommandClassForm.vcCommandNameComboBox.SelectedItem != null;
                }
            }
        }
        #endregion

        #region Other
        public void OnCommandClassesSelectedIndexChanged(object sender, EventArgs e)
        {
            ControllerManager.CommandClassForm.vcCommandNameComboBox.Items.Clear();
            ControllerManager.CommandClassForm.vcParametersGrid.SelectedObject = null;
            if (ControllerManager.CommandClassForm.vcCommandClassesComboBox.SelectedItem != null &&
                ControllerManager.CommandClassForm.vcCommandClassesComboBox.SelectedItem is CommandClass)
            {
                CommandClass commadClass = ControllerManager.CommandClassForm.vcCommandClassesComboBox.SelectedItem as CommandClass;
                if (commadClass.Command != null)
                {
                    foreach (Command cmd in commadClass.Command)
                    {
                        ControllerManager.CommandClassForm.vcCommandNameComboBox.Items.Add(cmd);
                    }
                }
            }
            OnDocumentModelStateChanged();
        }
        public void OnCommandSelectedIndexChanged(object sender, EventArgs e)
        {
            ParameterWrapperCollection parameters = new ParameterWrapperCollection();
            ControllerManager.CommandClassForm.vcParametersGrid.SelectedObject = null;
            if (ControllerManager.CommandClassForm.vcCommandNameComboBox.SelectedItem != null &&
                ControllerManager.CommandClassForm.vcCommandNameComboBox.SelectedItem is Command)
            {
                Command command = ControllerManager.CommandClassForm.vcCommandNameComboBox.SelectedItem as Command;
                if (command.Param != null)
                {
                    foreach (Param parameter in command.Param)
                    {
                        parameters.Add(ParamValue.CreateParamValue(parameter));
                    }
                }
                //parameters.Sort();
            }
            ControllerManager.CommandClassForm.vcParametersGrid.SelectedObject = parameters;
            OnDocumentModelStateChanged();
        }

        public void OnCommandReloadXmlClick(object sender, EventArgs e)
        {
            ControllerManager.ReloadXml();
            ReBuildList();
        }

        public void OnCommandSendClick(object sender, EventArgs e)
        {
            CommandClass cmdClass = null;
            Command cmd = null;
            ParameterWrapperCollection parameters = null;
            if (ControllerManager.CommandClassForm.vcCommandClassesComboBox.SelectedItem != null &&
                ControllerManager.CommandClassForm.vcCommandClassesComboBox.SelectedItem is CommandClass &&
                ControllerManager.CommandClassForm.vcCommandNameComboBox.SelectedItem != null &&
                ControllerManager.CommandClassForm.vcCommandNameComboBox.SelectedItem is Command &&
                ControllerManager.CommandClassForm.vcParametersGrid.SelectedObject != null &&
                ControllerManager.CommandClassForm.vcParametersGrid.SelectedObject is ParameterWrapperCollection)
            {
                cmdClass = (CommandClass)ControllerManager.CommandClassForm.vcCommandClassesComboBox.SelectedItem;
                cmd = (Command)ControllerManager.CommandClassForm.vcCommandNameComboBox.SelectedItem;
                parameters = (ParameterWrapperCollection)ControllerManager.CommandClassForm.vcParametersGrid.SelectedObject;
            }

            if (cmdClass != null && cmd != null && parameters != null && ControllerManager.DocumentModel.CurrentDevice != null)
            {
                List<ParamValue> parameterValues = parameters.ToParamValueList();
                ControllerManager.DoAction(
                    new ProcedureCaller<IController, IDeviceInfo, CommandClass, Command, List<ParamValue>, string>(CommandClassHAL.SendCommand),
                    new object[]{
                        ControllerManager.DocumentModel.Controller,
                        ControllerManager.DocumentModel.CurrentDevice,
                        cmdClass,
                        cmd,
                        parameterValues,
                        Resources.MsgSendCommand},
                    Resources.MsgSendCommand, true, (byte)CommandTypes.CmdZWaveSendData);
            }
        }

        public void OnCommandSendMetaClick(object sender, EventArgs e)
        {
            CommandClass cmdClass = null;
            Command cmd = null;
            ParameterWrapperCollection parameters = null;
            if (ControllerManager.CommandClassForm.vcCommandClassesComboBox.SelectedItem != null &&
                ControllerManager.CommandClassForm.vcCommandClassesComboBox.SelectedItem is CommandClass &&
                ControllerManager.CommandClassForm.vcCommandNameComboBox.SelectedItem != null &&
                ControllerManager.CommandClassForm.vcCommandNameComboBox.SelectedItem is Command &&
                ControllerManager.CommandClassForm.vcParametersGrid.SelectedObject != null &&
                ControllerManager.CommandClassForm.vcParametersGrid.SelectedObject is ParameterWrapperCollection)
            {
                cmdClass = (CommandClass)ControllerManager.CommandClassForm.vcCommandClassesComboBox.SelectedItem;
                cmd = (Command)ControllerManager.CommandClassForm.vcCommandNameComboBox.SelectedItem;
                parameters = (ParameterWrapperCollection)ControllerManager.CommandClassForm.vcParametersGrid.SelectedObject;
            }

            if (cmdClass != null && cmd != null && parameters != null && ControllerManager.DocumentModel.CurrentDevice != null)
            {
                List<ParamValue> parameterValues = parameters.ToParamValueList();
                ControllerManager.DoAction(
                    new ProcedureCaller<IController, IDeviceInfo, CommandClass, Command, List<ParamValue>, string>(CommandClassHAL.SendMetaCommand),
                    new object[]{
                        ControllerManager.DocumentModel.Controller,
                        ControllerManager.DocumentModel.CurrentDevice,
                        cmdClass,
                        cmd,
                        parameterValues,
                        Resources.MsgSendCommand},
                    Resources.MsgSendCommand, true, (byte)CommandTypes.CmdZWaveSendDataMeta);
            }
        }

        #endregion

        private void DevicesCollection_SelectedDeviceChanged(object sender, EventArgs e)
        {
            ReBuildList();
        }

        private delegate void ReBuildListDelegate();
        private void ReBuildList()
        {
            if (ControllerManager.CommandClassForm.InvokeRequired)
            {
                ControllerManager.CommandClassForm.Invoke(new ReBuildListDelegate(ReBuildList));
            }
            else
            {
                BuildList();
            }
        }
        private void BuildList()
        {
            ControllerManager.CommandClassForm.vcCommandClassesComboBox.Items.Clear();
            ControllerManager.CommandClassForm.vcCommandNameComboBox.Items.Clear();
            ControllerManager.CommandClassForm.vcParametersGrid.SelectedObject = null;
            if (ControllerManager.DocumentModel.CurrentDevice != null)
            {
                byte[] cmdClasses = new byte[0];
                //if (CustomLoader.GetEntryPoint().CustomCommandClassesStore != null && CustomLoader.GetEntryPoint().CustomCommandClassesStore.CmdClasses(ControllerManager.DocumentModel.CurrentDevice.Id) != null)
                //{
                //    cmdClasses = CustomLoader.GetEntryPoint().CustomCommandClassesStore.CmdClasses(ControllerManager.DocumentModel.CurrentDevice.Id);
                //    FillCC(cmdClasses);
                //}
                //else 
                if (ControllerManager.DocumentModel.CurrentDevice.SupportedCommandClasses != null)
                {
                    CommandClass commandClassBasic = ControllerManager.XmlDataManager.FindCommandClass("COMMAND_CLASS_BASIC", 1);
                    ControllerManager.CommandClassForm.vcCommandClassesComboBox.Items.Add(commandClassBasic);
                    FillCC(ControllerManager.DocumentModel.CurrentDevice.SupportedCommandClasses);
                }
            }
        }
        private void FillCC(byte[] cmdClasses)
        {
            foreach (byte cmdClass in cmdClasses)
            {
                List<CommandClass> commandClasses = ControllerManager.XmlDataManager.FindCommandClasses(cmdClass);
                if (commandClasses != null)
                {
                    foreach (CommandClass var in commandClasses)
                    {
                        ControllerManager.CommandClassForm.vcCommandClassesComboBox.Items.Add(var);
                    }
                }
            }
        }
    }
}
