using System;
using System.Collections.Generic;
using System.Text;
using Zensys.PCController.Interfaces;
using Zensys.PCController.Classes;
using Zensys.PCController.UI;
using Zensys.PCController.Models;

namespace Zensys.PCController.Dispatchers
{
    public class SetupRouteFormDispatcher : IViewDispatcher
    {
        #region IViewDispatcher Members

        public void Bind(IView view, ActionCollection actions, DocumentModel documentModel)
        {
            SetupRouteForm form = (SetupRouteForm)view;

            //Form
            form.Load += new EventHandler(actions.SetupRouteFormActions.OnFormLoad);
            form.FormClosing += new System.Windows.Forms.FormClosingEventHandler(actions.SetupRouteFormActions.OnFormClosing);

            form.vcAssignToolStripButton.Click += new EventHandler(actions.SetupRouteFormActions.OnAssignButtonClick);
            form.vcDeleteToolStripButton.Click += new EventHandler(actions.SetupRouteFormActions.OnDeleteButtonClick);

            //DocumentModel
            documentModel.DocumentModelStateChanged += new EventHandler<EventArgs>(actions.SetupRouteFormActions.OnDocumentModelStateChanged);
        }

        public void Drop(IView view, ActionCollection actions, DocumentModel documentModel)
        {
            SetupRouteForm form = (SetupRouteForm)view;

            //Form
            form.Load -= new EventHandler(actions.SetupRouteFormActions.OnFormLoad);
            form.FormClosing -= new System.Windows.Forms.FormClosingEventHandler(actions.SetupRouteFormActions.OnFormClosing);

            form.vcAssignToolStripButton.Click -= new EventHandler(actions.SetupRouteFormActions.OnAssignButtonClick);
            form.vcDeleteToolStripButton.Click -= new EventHandler(actions.SetupRouteFormActions.OnDeleteButtonClick);

            //DocumentModel
            documentModel.DocumentModelStateChanged -= new EventHandler<EventArgs>(actions.SetupRouteFormActions.OnDocumentModelStateChanged);
        }

        #endregion
    }
}
