using System;
using System.Collections.Generic;
using System.Text;
using Zensys.PCController.Interfaces;
using Zensys.PCController.Classes;
using Zensys.PCController.UI;
using Zensys.PCController.Models;
using System.Windows.Forms;

namespace Zensys.PCController.Dispatchers
{
    public class NodeFormDispatcher : IViewDispatcher
    {
        #region IViewDispatcher Members

        public void Bind(IView view, ActionCollection actions, DocumentModel documentModel)
        {
            NodeForm form = (NodeForm)view;

            //Form
            form.Load += new EventHandler(actions.NodeFormActions.OnFormLoad);
            form.FormClosing += new FormClosingEventHandler(actions.NodeFormActions.OnFormClosing);
            form.vcNodesListView.CellContentClick += new DataGridViewCellEventHandler(actions.NodeFormActions.CellContentClick);

            form.vcRequestNodeNeighborUpdateToolStripButton.Click += new EventHandler(actions.NodeFormActions.OnRequestNodeNeighborUpdateClick);
            form.vcAddNodeNetworkWideToolStripButton.Click += new EventHandler(actions.NodeFormActions.OnNetworkWideInclusionClick);
            form.vcAddNodeToolStripButton.Click += new EventHandler(actions.NodeFormActions.OnAddNodeClick);
            form.vcRemoveNodeToolStripButton.Click += new EventHandler(actions.NodeFormActions.OnRemoveNodeClick);
            form.vcNodeInfoToolStripButton.Click += new EventHandler(actions.NodeFormActions.OnNodeInfoClick);
            form.vcSetOnToolStripButton.Click += new EventHandler(actions.NodeFormActions.OnSetOnClick);
            form.vcSetOffToolStripButton.Click += new EventHandler(actions.NodeFormActions.OnSetOffClick);
            form.vcIsFailedNodeToolStripButton.Click += new EventHandler(actions.NodeFormActions.OnIsFailedNodeClick);
            form.vcReplaceFailedNodeToolStripButton.Click += new EventHandler(actions.NodeFormActions.OnReplaceFailedNodeClick);
            form.vcRemoveFailedNodeToolStripButton.Click += new EventHandler(actions.NodeFormActions.OnRemoveFailedNodeClick);

            form.vcSetAllOnToolStripButton.Click += new EventHandler(actions.NodeFormActions.OnSetAllOnClick);
            form.vcSetAllOffToolStripButton.Click += new EventHandler(actions.NodeFormActions.OnSetAllOffClick);

            form.vcSetWakeUpIntervalToolStripButton.Click += new EventHandler(actions.NodeFormActions.OnSetWakeUpIntervalClick);
			form.vcNopToolStripButton.Click += new EventHandler(actions.NodeFormActions.OnNopToolStripButtonClick);
            form.vcBasicToggleToolStripButton.Click += new EventHandler(actions.NodeFormActions.OnBasicToggleToolStripButtonClick);
            form.vcSetSucToolStripMenuItem.Click += new EventHandler(actions.NodeFormActions.OnSetSucToolStripMenuItemClick);
            form.vcSetSisToolStripMenuItem.Click += new EventHandler(actions.NodeFormActions.OnSetSisToolStripMenuItemClick);
            //DocumentModel
            documentModel.DocumentModelStateChanged += new EventHandler<EventArgs>(actions.NodeFormActions.OnDocumentModelStateChanged);
        }

        public void Drop(IView view, ActionCollection actions, DocumentModel documentModel)
        {
            NodeForm form = (NodeForm)view;

            //Form
            form.Load -= new EventHandler(actions.NodeFormActions.OnFormLoad);
            form.FormClosing -= new System.Windows.Forms.FormClosingEventHandler(actions.NodeFormActions.OnFormClosing);
            form.vcNodesListView.CellContentClick -= new DataGridViewCellEventHandler(actions.NodeFormActions.CellContentClick);

            form.vcRequestNodeNeighborUpdateToolStripButton.Click -= new EventHandler(actions.NodeFormActions.OnRequestNodeNeighborUpdateClick);
            form.vcAddNodeToolStripButton.Click -= new EventHandler(actions.NodeFormActions.OnAddNodeClick);
            form.vcRemoveNodeToolStripButton.Click -= new EventHandler(actions.NodeFormActions.OnRemoveNodeClick);
            form.vcNodeInfoToolStripButton.Click -= new EventHandler(actions.NodeFormActions.OnNodeInfoClick);
            form.vcSetOnToolStripButton.Click -= new EventHandler(actions.NodeFormActions.OnSetOnClick);
            form.vcSetOffToolStripButton.Click -= new EventHandler(actions.NodeFormActions.OnSetOffClick);
            form.vcIsFailedNodeToolStripButton.Click -= new EventHandler(actions.NodeFormActions.OnIsFailedNodeClick);
            form.vcReplaceFailedNodeToolStripButton.Click -= new EventHandler(actions.NodeFormActions.OnReplaceFailedNodeClick);
            form.vcRemoveFailedNodeToolStripButton.Click -= new EventHandler(actions.NodeFormActions.OnRemoveFailedNodeClick);

            form.vcSetWakeUpIntervalToolStripButton.Click -= new EventHandler(actions.NodeFormActions.OnSetWakeUpIntervalClick);
			form.vcNopToolStripButton.Click -= new EventHandler(actions.NodeFormActions.OnNopToolStripButtonClick);
            form.vcBasicToggleToolStripButton.Click -= new EventHandler(actions.NodeFormActions.OnBasicToggleToolStripButtonClick);
            form.vcSetSucToolStripMenuItem.Click -= new EventHandler(actions.NodeFormActions.OnSetSucToolStripMenuItemClick);
            form.vcSetSisToolStripMenuItem.Click -= new EventHandler(actions.NodeFormActions.OnSetSisToolStripMenuItemClick);
            //DocumentModel
            documentModel.DocumentModelStateChanged -= new EventHandler<EventArgs>(actions.NodeFormActions.OnDocumentModelStateChanged);
        }

        #endregion
    }
}
