using System;
using System.Collections.Generic;
using System.Text;
using Zensys.PCController.Interfaces;
using Zensys.PCController.Classes;
using Zensys.PCController.UI;
using Zensys.PCController.Models;

namespace Zensys.PCController.Dispatchers
{
    public class MainFormDispatcher : IViewDispatcher
    {
        #region IViewDispatcher Members

        public void Bind(IView view, ActionCollection actions, DocumentModel documentModel)
        {
            MainForm form = (MainForm)view;

            //Form
            form.Load += new EventHandler(actions.MainFormActions.OnFormLoad);
            form.FormClosing += new System.Windows.Forms.FormClosingEventHandler(actions.MainFormActions.OnFormClosing);
            form.KeyUp += new System.Windows.Forms.KeyEventHandler(actions.MainFormActions.OnKeyUp);
            
            ///Help
            form.AboutToolStripMenuItem.Click += new EventHandler(actions.MainFormActions.OnAboutToolStripMenuItemClick);
            form.IndexToolStripMenuItem.Click += new EventHandler(actions.MainFormActions.OnIndexToolStripMenuItemClick);
            form.SearchToolStripMenuItem.Click += new EventHandler(actions.MainFormActions.OnSearchToolStripMenuItemClick);
            form.ContentsToolStripMenuItem.Click += new EventHandler(actions.MainFormActions.OnContentsToolStripMenuItemClick);

            ///Views
            form.AssociationsToolStripMenuItem.Click += new EventHandler(actions.MainFormActions.OnAssociationsToolStripMenuItemClick);
            form.CmdClassToolStripMenuItem.Click += new EventHandler(actions.MainFormActions.OnCmdClassToolStripMenuItemClick);
            form.ControllerToolStripMenuItem.Click += new EventHandler(actions.MainFormActions.OnControllerToolStripMenuItemClick);
            form.NodeToolStripMenuItem.Click += new EventHandler(actions.MainFormActions.OnNodeToolStripMenuItemClick);
            form.SetupRouteToolStripMenuItem.Click += new EventHandler(actions.MainFormActions.OnSetupRouteToolStripMenuItemClick);
            form.LogToolStripMenuItem.Click += new EventHandler(actions.MainFormActions.OnLogToolStripMenuItemClick);
            form.ERTTToolStripMenuItem.Click += new EventHandler(actions.MainFormActions.OnErttClick);
            form.TopologyMapToolStripMenuItem.Click += new EventHandler(actions.MainFormActions.OnTopologyMapToolStripMenuItemClick);

            ///Other
            form.ExitToolStripMenuItem.Click += new EventHandler(actions.MainFormActions.OnExitToolStripMenuItemClick);
            form.SettingsToolStripMenuItem.Click += new EventHandler(actions.MainFormActions.OnSettingsToolStripMenuItemClick);

            form.CommandQueueStatusLabel.Click += new EventHandler(actions.MainFormActions.OnCommandQueueStatusLabelClick);
            form.SecurityTestSchemaToolStripMenuItem.Click += new EventHandler(actions.MainFormActions.OnSecurityTestSchemaClick);
        }

        public void Drop(IView view, ActionCollection actions, DocumentModel documentModel)
        {
            MainForm form = (MainForm)view;
            
            //Form
            form.Load -= new EventHandler(actions.MainFormActions.OnFormLoad);
            form.FormClosing -= new System.Windows.Forms.FormClosingEventHandler(actions.MainFormActions.OnFormClosing);
            form.KeyUp -= new System.Windows.Forms.KeyEventHandler(actions.MainFormActions.OnKeyUp);
            
            ///Help
            form.AboutToolStripMenuItem.Click -= new EventHandler(actions.MainFormActions.OnAboutToolStripMenuItemClick);
            form.IndexToolStripMenuItem.Click -= new EventHandler(actions.MainFormActions.OnIndexToolStripMenuItemClick);
            form.SearchToolStripMenuItem.Click -= new EventHandler(actions.MainFormActions.OnSearchToolStripMenuItemClick);
            form.ContentsToolStripMenuItem.Click -= new EventHandler(actions.MainFormActions.OnContentsToolStripMenuItemClick);

            ///Views
            form.AssociationsToolStripMenuItem.Click -= new EventHandler(actions.MainFormActions.OnAssociationsToolStripMenuItemClick);
            form.CmdClassToolStripMenuItem.Click -= new EventHandler(actions.MainFormActions.OnCmdClassToolStripMenuItemClick);
            form.ControllerToolStripMenuItem.Click -= new EventHandler(actions.MainFormActions.OnControllerToolStripMenuItemClick);
            form.NodeToolStripMenuItem.Click -= new EventHandler(actions.MainFormActions.OnNodeToolStripMenuItemClick);
            form.SetupRouteToolStripMenuItem.Click -= new EventHandler(actions.MainFormActions.OnSetupRouteToolStripMenuItemClick);
            form.LogToolStripMenuItem.Click -= new EventHandler(actions.MainFormActions.OnLogToolStripMenuItemClick);
            form.ERTTToolStripMenuItem.Click -= new EventHandler(actions.MainFormActions.OnErttClick);
            form.TopologyMapToolStripMenuItem.Click -= new EventHandler(actions.MainFormActions.OnTopologyMapToolStripMenuItemClick);

            ///Other
            form.ExitToolStripMenuItem.Click -= new EventHandler(actions.MainFormActions.OnExitToolStripMenuItemClick);
            form.SettingsToolStripMenuItem.Click -= new EventHandler(actions.MainFormActions.OnSettingsToolStripMenuItemClick);

            form.CommandQueueStatusLabel.Click -= new EventHandler(actions.MainFormActions.OnCommandQueueStatusLabelClick);
            form.SecurityTestSchemaToolStripMenuItem.Click -= new EventHandler(actions.MainFormActions.OnSecurityTestSchemaClick);
        }

        #endregion
    }
}
