using System;
using System.Collections.Generic;
using System.Text;
using Zensys.PCController.Interfaces;
using Zensys.PCController.UI;
using Zensys.PCController.Classes;
using Zensys.PCController.Models;

namespace Zensys.PCController.Dispatchers
{
    public class ErttFormDispatcher : IViewDispatcher
    {
        #region IViewDispatcher Members

        public void Bind(IView view, ActionCollection actions, DocumentModel documentModel)
        {
            ErttForm form = (ErttForm)view;
            form.Load += new EventHandler(actions.ErttFormActions.OnFormLoad);
            form.StartButton.Click += new EventHandler(actions.ErttFormActions.OnStartClick);
        }

        public void Drop(IView view, ActionCollection actions, DocumentModel documentModel)
        {
            ErttForm form = (ErttForm)view;
            form.Load -= new EventHandler(actions.ErttFormActions.OnFormLoad);
            form.StartButton.Click -= new EventHandler(actions.ErttFormActions.OnStartClick);
        }

        #endregion
    }
}
