using System;
using System.Collections.Generic;
using System.Text;
using Zensys.PCController.Controllers;
using Zensys.PCController.Actions;

namespace Zensys.PCController.Classes
{
    /// <summary>
    /// Represents a collection of <see cref="BaseAction"/>
    /// </summary>
    public class ActionCollection : BaseAction
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="ActionCollection"/> class.
        /// </summary>
        /// <param name="controller">The controller.</param>
        public ActionCollection(ControllerManager controller)
            : base(controller)
        {
        }

        private AssociationsFormActions mAssociationsFormActions;
        private CommandClassFormActions mCommandClassFormActions;
        private ControllerFormActions mControllerFormActions;
        private LogFormActions mLogFormActions;
        private MainFormActions mMainFormActions;
        private NodeFormActions mNodeFormActions;
        private SetupRouteFormActions mSetupRouteFormActions;
        private QueueActionsFormActions mQueueActionsFormActions;
        private CommonActions mCommonActions;
        private ErttFormActions mErttFormActions;
        private RoutingTableFormActions mRoutingTableFormActions;

        /// <summary>
        /// Gets or sets the routing table form actions.
        /// </summary>
        /// <value>The routing table form actions.</value>
        public RoutingTableFormActions RoutingTableFormActions
        {
            get
            {
                if (mRoutingTableFormActions == null) mRoutingTableFormActions = new RoutingTableFormActions(this.ControllerManager);
                return mRoutingTableFormActions;
            }
        }

        public ErttFormActions ErttFormActions
        {
            get
            {
                if (mErttFormActions == null) mErttFormActions = new ErttFormActions(this.ControllerManager);
                return mErttFormActions;
            }
        }

        public CommonActions CommonActions
        {
            get
            {
                if (mCommonActions == null) mCommonActions = new CommonActions(this.ControllerManager);
                return mCommonActions;
            }
        }
        /// <summary>
        /// Gets the associations form actions.
        /// </summary>
        /// <value>The associations form actions.</value>
        public AssociationsFormActions AssociationsFormActions
        {
            get
            {
                if (mAssociationsFormActions == null) mAssociationsFormActions = new AssociationsFormActions(this.ControllerManager);
                return mAssociationsFormActions;
            }
        }
        /// <summary>
        /// Gets the command class form actions.
        /// </summary>
        /// <value>The command class form actions.</value>
        public CommandClassFormActions CommandClassFormActions
        {
            get
            {
                if (mCommandClassFormActions == null) mCommandClassFormActions = new CommandClassFormActions(this.ControllerManager);
                return mCommandClassFormActions;
            }
        }
        /// <summary>
        /// Gets the controller form actions.
        /// </summary>
        /// <value>The controller form actions.</value>
        public ControllerFormActions ControllerFormActions
        {
            get
            {
                if (mControllerFormActions == null) mControllerFormActions = new ControllerFormActions(this.ControllerManager);
                return mControllerFormActions;
            }

        }
        /// <summary>
        /// Gets the log form actions.
        /// </summary>
        /// <value>The log form actions.</value>
        public LogFormActions LogFormActions
        {
            get
            {
                if (mLogFormActions == null) mLogFormActions = new LogFormActions(this.ControllerManager);
                return mLogFormActions;
            }
        }
        /// <summary>
        /// Gets the main form actions.
        /// </summary>
        /// <value>The main form actions.</value>
        public MainFormActions MainFormActions
        {
            get
            {
                if (mMainFormActions == null) mMainFormActions = new MainFormActions(this.ControllerManager);
                return mMainFormActions;
            }
        }
        /// <summary>
        /// Gets the node form actions.
        /// </summary>
        /// <value>The node form actions.</value>
        public NodeFormActions NodeFormActions
        {
            get
            {
                if (mNodeFormActions == null) mNodeFormActions = new NodeFormActions(this.ControllerManager);
                return mNodeFormActions;
            }
        }
        /// <summary>
        /// Gets the setup route form actions.
        /// </summary>
        /// <value>The setup route form actions.</value>
        public SetupRouteFormActions SetupRouteFormActions
        {
            get
            {
                if (mSetupRouteFormActions == null) mSetupRouteFormActions = new SetupRouteFormActions(this.ControllerManager);
                return mSetupRouteFormActions;
            }
        }

        /// <summary>
        /// Gets the Queue Actions Form actions.
        /// </summary>
        /// <value>The setup route form actions.</value>
        public QueueActionsFormActions QueueActionsFormActions
        {
            get
            {
                if (mQueueActionsFormActions == null) mQueueActionsFormActions = new QueueActionsFormActions(this.ControllerManager);
                return mQueueActionsFormActions;
            }
        }


    }
}
