using System;
using System.Collections.Generic;
using System.Text;
using Zensys.PCController.Classes;
using Zensys.PCController.Controllers;
using System.Windows.Forms;
using Zensys.ZWave.Devices;
using Zensys.PCController.Properties;
using Zensys.PCController.Models;
using Zensys.ZWave.Enums;

namespace Zensys.PCController.Actions
{
    public class RoutingTableFormActions : BaseAction
    {
        public RoutingTableFormActions(ControllerManager controller)
            : base(controller)
        {

        }
        #region Form
        public void OnFormLoad(object sender, EventArgs e)
        {
            ControllerManager.MainForm.TopologyMapToolStripMenuItem.Checked = true;
            ControllerManager.RoutingTableForm.TopologyMap.DataSource = ControllerManager.DocumentModel.TopologyMapItemCollection;
            ControllerManager.RoutingTableForm.PropertyGridNodeTypeColors.SelectedObject = new NodeTypeColors();

        }
        public void OnFormClosing(object sender, FormClosingEventArgs e)
        {
            ControllerManager.MainForm.TopologyMapToolStripMenuItem.Checked = false;
            //ControllerManager.RoutingTableForm.Hide();
            //e.Cancel = true;
        }
        #endregion

        public void OnReloadTopologyClick(object sender, EventArgs e)
        {
            ControllerManager.DoAction(new EventHandler(delegate
            {
                try
                {
                    ReloadTopology();

                }
                catch
                {

                }

            }), null, Resources.MsgReLoadingTopology, false, (byte)CommandTypes.None);
        }

        private void ReloadTopology()
        {
            if (ControllerManager.DocumentModel.Controller != null)
            {
                if (ControllerManager.DocumentModel.Controller.ConnectionStatus == Zensys.ZWave.Enums.ConnectionStatuses.Closed)
                {
                    ControllerManager.DocumentModel.Controller.Open(ControllerManager.DocumentModel.Controller.SerialPort);
                }
                ControllerManager.DocumentModel.TopologyMapItemCollection.BeginUpdate();
                ControllerManager.DocumentModel.TopologyMapItemCollection.Clear();
                ControllerManager.DocumentModel.Controller.GetNodes();
                foreach (IDeviceInfo device in ControllerManager.DocumentModel.Controller.IncludedNodes)
                {
                    byte[] routingInfo = ControllerManager.DocumentModel.Controller.GetRoutingInfo(device.Id, 0, 0);
                    ControllerManager.DocumentModel.TopologyMapItemCollection.Add(new TopologyMapItem(device, routingInfo, ControllerManager.XmlDataManager));
                }
                ControllerManager.DocumentModel.TopologyMapItemCollection.EndUpdate();
            }
        }
        public void OnDoRediscoveryClick(object sender, EventArgs e)
        {
            ControllerManager.DoAction(new EventHandler(delegate
            {
                if (ControllerManager.DocumentModel.Controller != null)
                {
                    if (ControllerManager.DocumentModel.Controller.ConnectionStatus == Zensys.ZWave.Enums.ConnectionStatuses.Closed)
                    {
                        ControllerManager.DocumentModel.Controller.Open(ControllerManager.DocumentModel.Controller.SerialPort);
                    }
                    if (ControllerManager.DocumentModel.CurrentDevice != null)
                    {
                        RequestNeighborUpdateStatuses result = ControllerManager.DocumentModel.Controller.RequestNodeNeighborUpdate(ControllerManager.DocumentModel.CurrentDevice.Id);
                        switch (result)
                        {
                            case RequestNeighborUpdateStatuses.RequestNeighborUpdateDone:
                                {
                                    ControllerManager.ShowMessage(Resources.MsgRequestNeighborUpdateDone, false);
                                } break;
                            case RequestNeighborUpdateStatuses.RequestNeighborUpdateFailed:
                                {
                                    ControllerManager.ShowMessage(Resources.MsgRequestNeighborUpdateFailed, false);
                                } break;
                            case RequestNeighborUpdateStatuses.RequestNeighborUpdateStarted: { } break;
                            default:
                                {
                                    ControllerManager.ShowMessage(Resources.MsgRequestNeighborUpdateFailed, false);
                                } break;
                        }
                    }
                }
            }), null, Resources.MsgRediscoveryProgress, false, (byte)CommandTypes.None);
            OnReloadTopologyClick(sender, e);

        }
        public void OnCheckLinkQuality(object sender, EventArgs e)
        {
            if (ControllerManager.RoutingTableForm != null && !ControllerManager.RoutingTableForm.IsDisposed)
            {
                if (ControllerManager.RoutingTableForm.TopologyMap.SelectedElement != null &&
                    ControllerManager.RoutingTableForm.TopologyMap.SelectedElement.VerticalNode != null &&
                    ControllerManager.RoutingTableForm.TopologyMap.SelectedElement.HorizontalNode != null &&
                    ControllerManager.RoutingTableForm.TopologyMap.SelectedElement.VerticalNode.Tag != null &&
                    ControllerManager.RoutingTableForm.TopologyMap.SelectedElement.VerticalNode.Tag != null)
                {
                    IDeviceInfo srcDevice = ControllerManager.RoutingTableForm.TopologyMap.SelectedElement.VerticalNode.Tag.Device;
                    IDeviceInfo destDevice = ControllerManager.RoutingTableForm.TopologyMap.SelectedElement.HorizontalNode.Tag.Device;
                    byte txLevel = (byte)ControllerManager.RoutingTableForm.TxLevelNumericUpDown.Value;
                    byte numberOfFrames = (byte)ControllerManager.RoutingTableForm.NumberOfFramesNumericUpDown.Value;

                    ControllerManager.DoAction(new EventHandler(delegate
                    {
                        if (ControllerManager.DocumentModel.Controller != null)
                        {
                            if (ControllerManager.DocumentModel.Controller.ConnectionStatus == Zensys.ZWave.Enums.ConnectionStatuses.Closed)
                            {
                                ControllerManager.DocumentModel.Controller.Open(ControllerManager.DocumentModel.Controller.SerialPort);
                            }
                            TimeSpan oldRequestTimeout = ControllerManager.ZWaveManager.SessionLayer.RequestTimeout;
                            if (numberOfFrames > 40)
                            {
                                ControllerManager.ZWaveManager.SessionLayer.RequestTimeout = new TimeSpan(0, 0, 10);
                            }
                            List<byte[]> response = new List<byte[]>();
                                //@//TransmitStatuses ret = ControllerManager.DocumentModel.Controller.SendData
                                //@//(srcDevice.Id, FrameGenerator.Zw_PowerlevelTestNodeSetFrame(destDevice.Id, txLevel, (byte)(numberOfFrames >> 8), numberOfFrames),
                                //@//TransmitOptions.TransmitOptionAutoRoute | TransmitOptions.TransmitOptionAcknowledge); //TODO was 3

                            
                            ControllerManager.ZWaveManager.SessionLayer.RequestTimeout = oldRequestTimeout;

                        }
                    }), null, Resources.MsgCheckLinkQualityProgress, false, (byte)CommandTypes.None);

                }
            }
        }
        public void OnNodeTypeColorsPropertyValueChanged(object sender, PropertyValueChangedEventArgs e)
        {
            if (sender is PropertyGrid)
            {
                PropertyGrid grid = sender as PropertyGrid;
                if (grid.SelectedObject != null && grid.SelectedObject is NodeTypeColors)
                {
                    ((NodeTypeColors)grid.SelectedObject).Save();
                    ControllerManager.DoAction(new EventHandler(delegate
                        {
                            try
                            {
                                ReloadTopology();

                            }
                            catch
                            {

                            }

                        }), null, Resources.MsgReLoadingTopology, false, (byte)CommandTypes.None);
                }
            }
        }
    }
}
