using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.InstallerTool.Interfaces;
using Zensys.ZWave.InstallerTool.Classes;
using Zensys.ZWave.InstallerTool.UI;
using Zensys.ZWave.InstallerTool.Models;
using System.Windows.Forms;

namespace Zensys.ZWave.InstallerTool.Dispatchers
{
    public class NodeFormDispatcher : IViewDispatcher
    {
        #region IViewDispatcher Members

        public void Bind(IView view, ActionCollection actions, DocumentModel documentModel)
        {
            NodeForm form = (NodeForm)view;

            //Form
            form.Load += new EventHandler(actions.NodeFormActions.OnFormLoad);
            form.FormClosing += new FormClosingEventHandler(actions.NodeFormActions.OnFormClosing);
            form.vcNodeInfoToolStripButton.Click += new EventHandler(actions.NodeFormActions.OnNodeInfoClick);

            form.vcAddNodeToolStripButton.Click += new EventHandler(actions.NodeFormActions.OnAddNodeClick);
            form.vcRemoveNodeToolStripButton.Click += new EventHandler(actions.NodeFormActions.OnRemoveNodeClick);
            form.vcSetOnToolStripButton.Click += new EventHandler(actions.NodeFormActions.OnSetOnClick);
            form.vcSetOffToolStripButton.Click += new EventHandler(actions.NodeFormActions.OnSetOffClick);

            form.vcSetAllOnToolStripButton.Click += new EventHandler(actions.NodeFormActions.OnSetAllOnClick);
            form.vcSetAllOffToolStripButton.Click += new EventHandler(actions.NodeFormActions.OnSetAllOffClick);

            form.vcReachNodeToolStripButton.Click += new EventHandler(actions.NodeFormActions.OnReachNodeClick);
            form.vcBasicToggleToolStripButton.Click += new EventHandler(actions.NodeFormActions.OnBasicToggleToolStripButtonClick);
            //DocumentModel
            documentModel.DocumentModelStateChanged += new EventHandler<EventArgs>(actions.NodeFormActions.OnDocumentModelStateChanged);
        }

        public void Drop(IView view, ActionCollection actions, DocumentModel documentModel)
        {
            NodeForm form = (NodeForm)view;

            //Form
            form.Load -= new EventHandler(actions.NodeFormActions.OnFormLoad);
            form.FormClosing -= new System.Windows.Forms.FormClosingEventHandler(actions.NodeFormActions.OnFormClosing);
            form.vcNodeInfoToolStripButton.Click -= new EventHandler(actions.NodeFormActions.OnNodeInfoClick);

            form.vcAddNodeToolStripButton.Click -= new EventHandler(actions.NodeFormActions.OnAddNodeClick);
            form.vcRemoveNodeToolStripButton.Click -= new EventHandler(actions.NodeFormActions.OnRemoveNodeClick);
            form.vcSetOnToolStripButton.Click -= new EventHandler(actions.NodeFormActions.OnSetOnClick);
            form.vcSetOffToolStripButton.Click -= new EventHandler(actions.NodeFormActions.OnSetOffClick);

            form.vcReachNodeToolStripButton.Click -= new EventHandler(actions.NodeFormActions.OnReachNodeClick);
            form.vcBasicToggleToolStripButton.Click -= new EventHandler(actions.NodeFormActions.OnBasicToggleToolStripButtonClick);
            //DocumentModel
            documentModel.DocumentModelStateChanged -= new EventHandler<EventArgs>(actions.NodeFormActions.OnDocumentModelStateChanged);
        }

        #endregion
    }
}
