using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.InstallerTool.UI;
using Zensys.ZWave.InstallerTool.Interfaces;
using Zensys.ZWave.InstallerTool.Models;
using Zensys.ZWave.InstallerTool.Classes;

namespace Zensys.ZWave.InstallerTool.Dispatchers
{
    /// <summary>
    /// MainFormDispatcher class. Bind/Unbind functions to the Main Form controls.
    /// </summary>
    public class MainFormDispatcher : IViewDispatcher
    {
        #region IViewDispatcher Members
        /// <summary>
        /// Binds the functions to the specified view.
        /// </summary>
        /// <param name="view">The view.</param>
        /// <param name="actions">The actions (functions).</param>
        public void Bind(IView view, ActionCollection actions, DocumentModel documentModel)
        {
            MainForm form = (MainForm)view;

            #region Form
            form.Load += new EventHandler(actions.MainFormActions.OnFormLoad);
            form.FormClosing += new System.Windows.Forms.FormClosingEventHandler(actions.MainFormActions.OnFormClosing);

            form.MainDockPanel.ActiveContentChanged += new EventHandler(actions.MainFormActions.OnActiveContentChanged);
            #endregion
            
            form.ControllerToolStripMenuItem.Click += new EventHandler(actions.MainFormActions.OnControllerToolStripMenuItemClick);
            form.NodeToolStripMenuItem.Click += new EventHandler(actions.MainFormActions.OnNodeToolStripMenuItemClick);
            form.LogToolStripMenuItem.Click += new EventHandler(actions.MainFormActions.OnLogToolStripMenuItemClick);
            form.TopologyMapToolStripMenuItem.Click += new EventHandler(actions.MainFormActions.OnTopologyMapToolStripMenuItemClick);

            form.ExitToolStripMenuItem.Click += new EventHandler(actions.MainFormActions.OnExitToolStripMenuItemClick);
            form.SettingsToolStripMenuItem.Click += new EventHandler(actions.MainFormActions.OnSettingsToolStripMenuItemClick);

            form.AboutToolStripMenuItem.Click += new EventHandler(actions.MainFormActions.OnAboutToolStripMenuItemClick);

        }

        /// <summary>
        /// Drops the functions to the specified view.
        /// </summary>
        /// <param name="view">The view.</param>
        /// <param name="actions">The actions (functions).</param>
        public void Drop(IView view, ActionCollection actions, DocumentModel documentModel)
        {
            MainForm form = (MainForm)view;

            #region Form
            form.Load -= new EventHandler(actions.MainFormActions.OnFormLoad);
            form.FormClosing -= new System.Windows.Forms.FormClosingEventHandler(actions.MainFormActions.OnFormClosing);

            form.MainDockPanel.ActiveContentChanged -= new EventHandler(actions.MainFormActions.OnActiveContentChanged);
            #endregion

            form.ControllerToolStripMenuItem.Click -= new EventHandler(actions.MainFormActions.OnControllerToolStripMenuItemClick);
            form.NodeToolStripMenuItem.Click -= new EventHandler(actions.MainFormActions.OnNodeToolStripMenuItemClick);
            form.LogToolStripMenuItem.Click -= new EventHandler(actions.MainFormActions.OnLogToolStripMenuItemClick);
            form.TopologyMapToolStripMenuItem.Click -= new EventHandler(actions.MainFormActions.OnTopologyMapToolStripMenuItemClick);

            form.ExitToolStripMenuItem.Click -= new EventHandler(actions.MainFormActions.OnExitToolStripMenuItemClick);
            form.SettingsToolStripMenuItem.Click -= new EventHandler(actions.MainFormActions.OnSettingsToolStripMenuItemClick);
            
            form.AboutToolStripMenuItem.Click -= new EventHandler(actions.MainFormActions.OnAboutToolStripMenuItemClick);

        }

        #endregion
    }
}
