using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Drawing.Drawing2D;
using Zensys.ZWave.InstallerTool.Models;

namespace Zensys.ZWave.InstallerTool.Controls.Drawing
{
    public class TopologyMapNode : TopologyMapShape
    {
        public enum NodeTypes
        {
            None,
            Horizontal,
            Vertical
        }

        private int mIndex = 0;
        private NodeTypes mType = NodeTypes.None;

        public NodeTypes Type
        {
            get { return mType; }
            set { mType = value; }
        }
        public int Index
        {
            get { return mIndex; }
            set { mIndex = value; }
        }
        private TopologyMapItem mTag;

        public TopologyMapItem Tag
        {
            get { return mTag; }
            set { mTag = value; }
        }
        public override void Paint(Graphics graphics)
        {
            if (this.Site != null)
            {
                graphics.SmoothingMode = SmoothingMode.AntiAlias;
                if (this.Type == NodeTypes.Horizontal)
                {
                    this.Location = new Point(this.Site.MarginLeft + (TopologyMapCanvas.ELEMENT_WIDTH - TopologyMapCanvas.NODE_WIDTH) / 2 + (this.Index * (TopologyMapCanvas.NODE_WIDTH + TopologyMapCanvas.ELEMENT_WIDTH - TopologyMapCanvas.NODE_WIDTH)),
                        this.Site.MarginTop - (TopologyMapCanvas.NODE_HEIGHT + this.Site.PaddingTop));
                }
                else if (this.Type == NodeTypes.Vertical)
                {
                    this.Location = new Point(this.Site.MarginLeft - (TopologyMapCanvas.NODE_WIDTH + this.Site.PaddingLeft),
                        this.Site.MarginTop + (TopologyMapCanvas.ELEMENT_HEIGHT - TopologyMapCanvas.NODE_HEIGHT) / 2 + this.Index * (TopologyMapCanvas.NODE_HEIGHT + TopologyMapCanvas.ELEMENT_HEIGHT - TopologyMapCanvas.NODE_HEIGHT));
                }
                this.Bounds = new Rectangle(this.Location.X, this.Location.Y, TopologyMapCanvas.NODE_WIDTH, TopologyMapCanvas.NODE_HEIGHT);
                GraphicsPath path = GetPath(0);
                GraphicsPath shadowPath = GetPath(4);
                graphics.FillPath(new SolidBrush(Color.LightGray), shadowPath);
                LinearGradientBrush brush = new LinearGradientBrush(this.Bounds, Color.White, this.BackColor, 90);
                graphics.FillPath(brush, path);
                graphics.DrawPath(this.DefaultPen, path);

                if (!String.IsNullOrEmpty(this.Label))
                {
                    DrawLabel(graphics);
                }
            }
        }

        private void DrawLabel(Graphics graphics)
        {
            StringFormat sf = new StringFormat();
            sf.Alignment = StringAlignment.Center;
            graphics.DrawString(this.Label, this.DefaultFont, this.DefaultPen.Brush, this.Bounds, sf);
        }

        private int radius = 8;
        private GraphicsPath GetPath(int shift)
        {
            GraphicsPath path = new GraphicsPath();
            path.AddArc(this.Bounds.X, this.Bounds.Y, radius, radius, 180, 90);
            path.AddLine(this.Bounds.X + radius / 2, this.Bounds.Y, this.Bounds.Right - radius, this.Bounds.Y);
            path.AddArc(this.Bounds.Right - radius, this.Bounds.Y, radius, radius, 270, 90);
            path.AddLine(this.Bounds.Right, this.Bounds.Y + radius / 2, this.Bounds.Right, this.Bounds.Bottom - radius);
            path.AddArc(this.Bounds.Right - radius, this.Bounds.Bottom - radius, radius, radius, 0, 90);
            path.AddLine(this.Bounds.Right - radius, this.Bounds.Bottom, this.Bounds.Left + radius, this.Bounds.Bottom);
            path.AddArc(this.Bounds.Left, this.Bounds.Bottom - radius, radius, radius, 90, 90);
            path.CloseFigure();
            if (shift != 0)
            {
                Matrix matrix = new Matrix();
                matrix.Translate(shift, shift);
                path.Transform(matrix);
            }
            return path;
        }
    }
}
