using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.Devices;
using Zensys.Framework;

namespace Zensys.ZWave.InstallerTool.Classes
{
    public class DeviceWrapper
    {
        public DeviceWrapper(Win32PnPEntityClass portInfo, IInstallerController device)
        {
            mDevice = device;
            mPortInfo = portInfo;
        }
        private IInstallerController mDevice;
        public IInstallerController Device
        {
            get { return mDevice; }
            set { mDevice = value; }
        }

        private Win32PnPEntityClass mPortInfo;
        public Win32PnPEntityClass PortInfo
        {
            get { return mPortInfo; }
            set { mPortInfo = value; }
        }

        public override string ToString()
        {
            return String.Format("{0}:{1}{2}",
                PortInfo.Caption,
                (Device==null)?"":" ", 
                (Device==null)?"":Device.Version.Library.ToString());
        }
    }
}
