using System;
using System.Collections.Generic;
using System.Text;
using Zensys.Framework;
using System.Windows.Forms;
using System.ComponentModel;
using System.Collections;
using System.Reflection;

namespace Zensys.Framework.UI.Controls.TreeDataView
{
    //TO DO can be improved by replacing reflection with generic collections or overrided methods
    public abstract class TreeDataView<T> : TreeView
    {
        private BindingList<T> mDataSource;
        private CurrencyManager mCurrencyManager = null;
        private List<Branch> mBranches = new List<Branch>();
        protected List<Branch> Branches
        {
            get { return mBranches; }
        }

        [Category("Data")]
        public BindingList<T> DataSource
        {
            get
            {
                return mDataSource;
            }
            set
            {
                if (value != null)
                {
                    mDataSource = value;
                    mCurrencyManager = (CurrencyManager)this.BindingContext[value];
                    BuildTree();
                }
                else
                {
                    this.mCurrencyManager = null;
                    this.Nodes.Clear();
                }
            }
        }

        public IBindingList mSelectedDataSource;
        public IBindingList SelectedDataSource
        {
            get { return mSelectedDataSource; }
        }

        public IBindingList mNewSelectedDataSource;
        public IBindingList NewSelectedDataSource
        {
            get { return mNewSelectedDataSource; }
        }

        public void BuildTree()
        {
            BeginUpdate();
            this.Nodes.Clear();
            foreach (Branch branch in Branches)
            {
                foreach (object obj in mCurrencyManager.List)
                { 
                    //find branch in list
                    PropertyDescriptor listDescriptor = mCurrencyManager.GetItemProperties()[branch.DataList];
                    if (listDescriptor != null)
                    {
                        TreeNode rootnode = new TreeNode();
                        rootnode.Text = branch.DataList;
                        foreach (object var in (IEnumerable)listDescriptor.GetValue(obj))
                        {
                            TreeNode node = new TreeNode();
                            Type type = var.GetType();
                            node.Tag = var;// type.GetProperty(branch.ValueMember).GetValue(var, null);
                            object[] displayObjects = new object[branch.DisplayMembers.Length];
                            for (int i = 0; i < branch.DisplayMembers.Length; i++)
                            {
                                displayObjects[i] = type.GetProperty(branch.DisplayMembers[i]).GetValue(var, null);
                            }
                            node.Text = string.Format(branch.DisplayFormat, displayObjects);
                            AddSubNodes(branch.InnerBranches, node, var);
                            rootnode.Nodes.Add(node);
                        }
                        Nodes.Add(rootnode);
                    }
                }
            }
            EndUpdate();
        }

        private void AddSubNodes(List<Branch> list, TreeNode node, object obj)
        {
            foreach (Branch branch in list)
            {
                Type subtype = obj.GetType();
                PropertyInfo pinfo = subtype.GetProperty(branch.DataList);
                if (pinfo != null)
                {
                    foreach (object var in (IEnumerable)pinfo.GetValue(obj, null))
                    {
                        TreeNode subnode = new TreeNode();
                        Type type = var.GetType();
                        subnode.Tag = var;//type.GetProperty(branch.ValueMember).GetValue(var, null);
                        object[] displayObjects = new object[branch.DisplayMembers.Length];
                        for (int i = 0; i < branch.DisplayMembers.Length; i++)
                        {
                            displayObjects[i] = type.GetProperty(branch.DisplayMembers[i]).GetValue(var, null);
                        }
                        subnode.Text = string.Format(branch.DisplayFormat, displayObjects);
                        AddSubNodes(branch.InnerBranches, subnode, var);
                        node.Nodes.Add(subnode);
                    }
                }
            }
        }

        void dataSource_PropertyChanged(object sender, PropertyChangedEventArgs e)
        {
            
        }

        void dataSource_CollectionChanged(object sender, NotifyCollectionChangedEventArgs e)
        {
            
        }

        protected override void Dispose(bool disposing)
        {
            base.Dispose(disposing);
            if (mDataSource != null)
            {
            }
        }

        //private delegate void ReAddSessionNodeDelegate(LogSession sender, SessionDataAddedEventArgs e);
        //private void ReAddSessionNode(LogSession sender, SessionDataAddedEventArgs e)
        //{
        //    if (InvokeRequired)
        //    {
        //        Invoke(new ReAddSessionNodeDelegate(ReAddSessionNode), new object[] { sender, e });
        //    }
        //    else
        //    {
        //        AddSessionNode(e.Session);
        //        if (sender != null)
        //        {
        //            LogSession ls = (LogSession)sender;
        //            //SelectNode(ls.Id);
        //        }
        //    }
        //}

        //private delegate void ReBuildTreeDelegate(LogSession sender);
        //private void ReBuildTree(LogSession sender)
        //{
        //    if (InvokeRequired)
        //    {
        //        Invoke(new ReBuildTreeDelegate(ReBuildTree), new object[] { sender });
        //    }
        //    else
        //    {
        //        BuildTree();
        //        if (sender != null)
        //        {
        //            LogSession ls = (LogSession)sender;
        //            //SelectNode(ls.Id);
        //        }
        //    }
        //}
    }
}
