using System;
using System.Collections.Generic;
using System.Text;
using System.Management;
using System.Reflection;
using System.Collections;

namespace Zensys.Framework
{
    public class ComputerSystemHardwareHelper
    {
        #region Static Methods
        public static List<Win32SerialPortClass> GetWin32SerialPortClassDevices()
        {
            List<Win32SerialPortClass> result = new List<Win32SerialPortClass>();
            try
            {
                ManagementObjectSearcher searcher = new ManagementObjectSearcher("select * from Win32_SerialPort");
                foreach (ManagementObject managementObject in searcher.Get())
                {
                    Win32SerialPortClass portInfo = new Win32SerialPortClass();
                    MapObject2Win32SerialPortClass(managementObject, portInfo);
                    result.Add(portInfo);
                }
                searcher.Dispose();
            }
            catch (Exception ex)
            {
                throw ex;
            }
            return result;
        }
        public static Win32SerialPortClass GetWin32SerialPortClassDevice(string deviceId)
        {
            List<Win32SerialPortClass> list = GetWin32SerialPortClassDevices("DeviceID = \"" + deviceId + "\"");
            if (list.Count == 1)
            {
                return list[0];
            }
            return null;
        }
        public static List<Win32SerialPortClass> GetWin32SerialPortClassDevices(string condition)
        {
            List<Win32SerialPortClass> result = new List<Win32SerialPortClass>();
            try
            {
                ManagementObjectSearcher searcher = new ManagementObjectSearcher("select * from Win32_SerialPort where " + condition);
                foreach (ManagementObject managementObject in searcher.Get())
                {
                    Win32SerialPortClass portInfo = new Win32SerialPortClass();
                    MapObject2Win32SerialPortClass(managementObject, portInfo);
                    result.Add(portInfo);
                }
                searcher.Dispose();
            }
            catch (Exception ex)
            {
                throw ex;
            }
            return result;


        }
        public static List<Win32PnPEntityClass> GetWin32PnPEntityClassSerialPortDevices()
        {
            List<Win32PnPEntityClass> result = new List<Win32PnPEntityClass>();
            try
            {
                serialPortNames = new List<string>(System.IO.Ports.SerialPort.GetPortNames());
                ManagementObjectSearcher searcher = new ManagementObjectSearcher("select * from Win32_PnPEntity where ClassGuid = '{4D36E978-E325-11CE-BFC1-08002BE10318}' and Service <> 'Parport' ");
                foreach (ManagementObject managementObject in searcher.Get())
                {
                    Win32PnPEntityClass portInfo = new Win32PnPEntityClass();
                    MapObject2Win32PnPEntityClass(managementObject, portInfo);
                    result.Add(portInfo);
                }
                searcher.Dispose();
            }
            catch (Exception ex)
            {
                throw ex;
            }
            return result;
        }
        public static Win32PnPEntityClass GetWin32PnPEntityClassSerialPortDevice(string deviceId)
        {
            Win32PnPEntityClass result = null;
            List<Win32PnPEntityClass> list = GetWin32PnPEntityClassSerialPortDevices();
            foreach (Win32PnPEntityClass device in list)
            {
                if (device.DeviceID == deviceId)
                {
                    result = device;
                    break;
                }
            }
            return result;
        }
        public static List<Win32PnPEntityClass> GetWin32PnPEntityClassSerialPortDevices(string condition)
        {
            List<Win32PnPEntityClass> result = new List<Win32PnPEntityClass>();
            try
            {
                if (!condition.Trim().ToUpper().StartsWith("AND"))
                {
                    condition = " and " + condition;
                }
                ManagementObjectSearcher searcher = new ManagementObjectSearcher("select * from Win32_PnPEntity where ClassGuid = '{4D36E978-E325-11CE-BFC1-08002BE10318}' and Service <> 'Parport' " + condition);
                foreach (ManagementObject managementObject in searcher.Get())
                {
                    Win32PnPEntityClass portInfo = new Win32PnPEntityClass();
                    MapObject2Win32PnPEntityClass(managementObject, portInfo);
                    result.Add(portInfo);
                }
                searcher.Dispose();
            }
            catch (Exception ex)
            {
                throw ex;
            }
            return result;


        }
        public static List<Win32PnPEntityClass> GetWin32PnPEntityClassDevices()
        {
            List<Win32PnPEntityClass> result = new List<Win32PnPEntityClass>();
            try
            {
                //select * from Win32_PnPEntity where ClassGuid = '{4D36E978-E325-11CE-BFC1-08002BE10318}' and Service <> 'Parport'"
                ManagementObjectSearcher searcher = new ManagementObjectSearcher("select * from Win32_PnPEntity");
                foreach (ManagementObject managementObject in searcher.Get())
                {
                    Win32PnPEntityClass portInfo = new Win32PnPEntityClass();
                    MapObject2Win32PnPEntityClass(managementObject, portInfo);
                    result.Add(portInfo);
                }
                searcher.Dispose();
            }
            catch (Exception ex)
            {
                throw ex;
            }
            return result;
        }
        public static Win32PnPEntityClass GetWin32PnPEntityClassDevice(string deviceId)
        {
            List<Win32PnPEntityClass> list = GetWin32PnPEntityClassDevices("DeviceID = \"" + deviceId + "\"");
            if (list.Count == 1)
            {
                return list[0];
            }
            return null;
        }
        public static List<Win32PnPEntityClass> GetWin32PnPEntityClassDevices(string condition)
        {
            List<Win32PnPEntityClass> result = new List<Win32PnPEntityClass>();
            try
            {
                ManagementObjectSearcher searcher = new ManagementObjectSearcher("select * from Win32_PnPEntity where " + condition);
                foreach (ManagementObject managementObject in searcher.Get())
                {
                    Win32PnPEntityClass portInfo = new Win32PnPEntityClass();
                    MapObject2Win32PnPEntityClass(managementObject, portInfo);
                    result.Add(portInfo);
                }
                searcher.Dispose();
            }
            catch (Exception ex)
            {
                throw ex;
            }
            return result;


        }
        #endregion
        #region Private Methods
        private static List<string> serialPortNames = new List<string>();
        private static void MapObject2BaseWin32DeviceClass(ManagementObject managementObject, BaseWin32DeviceClass device)
        {
            if (managementObject.Properties["Availability"] != null && managementObject.Properties["Availability"].Value != null)
                device.Availability = (ushort?)managementObject.Properties["Availability"].Value;

            if (managementObject.Properties["Caption"] != null && managementObject.Properties["Caption"].Value != null)
            {
                device.Caption = (string)managementObject.Properties["Caption"].Value;
            }

            if (managementObject.Properties["ConfigManagerErrorCode"] != null && managementObject.Properties["ConfigManagerErrorCode"].Value != null)
                device.ConfigManagerErrorCode = (uint?)managementObject.Properties["ConfigManagerErrorCode"].Value;

            if (managementObject.Properties["ConfigManagerUserConfig"] != null && managementObject.Properties["ConfigManagerUserConfig"].Value != null)
                device.ConfigManagerUserConfig = (bool?)managementObject.Properties["ConfigManagerUserConfig"].Value;

            if (managementObject.Properties["CreationClassName"] != null && managementObject.Properties["CreationClassName"].Value != null)
                device.CreationClassName = (string)managementObject.Properties["CreationClassName"].Value;

            if (managementObject.Properties["Description"] != null && managementObject.Properties["Description"].Value != null)
                device.Description = (string)managementObject.Properties["Description"].Value;

            if (managementObject.Properties["DeviceID"] != null && managementObject.Properties["DeviceID"].Value != null)
                device.DeviceID = (string)managementObject.Properties["DeviceID"].Value;

            if (managementObject.Properties["Name"] != null && managementObject.Properties["Name"].Value != null)
                device.Name = (string)managementObject.Properties["Name"].Value;

            if (managementObject.Properties["PNPDeviceID"] != null && managementObject.Properties["PNPDeviceID"].Value != null)
                device.PNPDeviceID = (string)managementObject.Properties["PNPDeviceID"].Value;

            if (managementObject.Properties["PowerManagementCapabilities"] != null && managementObject.Properties["PowerManagementCapabilities"].Value != null)
                device.PowerManagementCapabilities = (UInt16[])managementObject.Properties["PowerManagementCapabilities"].Value;

            if (managementObject.Properties["PowerManagementSupported"] != null && managementObject.Properties["PowerManagementSupported"].Value != null)
                device.PowerManagementSupported = (bool?)managementObject.Properties["PowerManagementSupported"].Value;

            if (managementObject.Properties["Status"] != null && managementObject.Properties["Status"].Value != null)
                device.Status = (string)managementObject.Properties["Status"].Value;

            if (managementObject.Properties["StatusInfo"] != null && managementObject.Properties["StatusInfo"].Value != null)
                device.StatusInfo = (ushort?)managementObject.Properties["StatusInfo"].Value;

            if (managementObject.Properties["SystemCreationClassName"] != null && managementObject.Properties["SystemCreationClassName"].Value != null)
                device.SystemCreationClassName = (string)managementObject.Properties["SystemCreationClassName"].Value;

            if (managementObject.Properties["SystemName"] != null && managementObject.Properties["SystemName"].Value != null)
                device.SystemName = (string)managementObject.Properties["SystemName"].Value;
        }
        private static void MapObject2Win32SerialPortClass(ManagementObject managementObject, Win32SerialPortClass portInfo)
        {
            MapObject2BaseWin32DeviceClass(managementObject, portInfo);
            if (managementObject.Properties["Binary"] != null && managementObject.Properties["Binary"].Value != null)
                portInfo.Binary = (bool?)managementObject.Properties["Binary"].Value;

            if (managementObject.Properties["MaxBaudRate"] != null && managementObject.Properties["MaxBaudRate"].Value != null)
                portInfo.MaxBaudRate = (uint?)managementObject.Properties["MaxBaudRate"].Value;

            if (managementObject.Properties["MaximumInputBufferSize"] != null && managementObject.Properties["MaximumInputBufferSize"].Value != null)
                portInfo.MaximumInputBufferSize = (uint?)managementObject.Properties["MaximumInputBufferSize"].Value;

            if (managementObject.Properties["MaximumOutputBufferSize"] != null && managementObject.Properties["MaximumOutputBufferSize"].Value != null)
                portInfo.MaximumOutputBufferSize = (uint?)managementObject.Properties["MaximumOutputBufferSize"].Value;

            if (managementObject.Properties["OSAutoDiscovered"] != null && managementObject.Properties["OSAutoDiscovered"].Value != null)
                portInfo.OSAutoDiscovered = (bool?)managementObject.Properties["OSAutoDiscovered"].Value;

            if (managementObject.Properties["ProviderType"] != null && managementObject.Properties["ProviderType"].Value != null)
                portInfo.ProviderType = (string)managementObject.Properties["ProviderType"].Value;

            if (managementObject.Properties["SettableBaudRate"] != null && managementObject.Properties["SettableBaudRate"].Value != null)
                portInfo.SettableBaudRate = (bool?)managementObject.Properties["SettableBaudRate"].Value;

            if (managementObject.Properties["SettableDataBits"] != null && managementObject.Properties["SettableDataBits"].Value != null)
                portInfo.SettableDataBits = (bool?)managementObject.Properties["SettableDataBits"].Value;

            if (managementObject.Properties["SettableFlowControl"] != null && managementObject.Properties["SettableFlowControl"].Value != null)
                portInfo.SettableFlowControl = (bool?)managementObject.Properties["SettableFlowControl"].Value;

            if (managementObject.Properties["SettableParity"] != null && managementObject.Properties["SettableParity"].Value != null)
                portInfo.SettableParity = (bool?)managementObject.Properties["SettableParity"].Value;

            if (managementObject.Properties["SettableParityCheck"] != null && managementObject.Properties["SettableParityCheck"].Value != null)
                portInfo.SettableParityCheck = (bool?)managementObject.Properties["SettableParityCheck"].Value;

            if (managementObject.Properties["SettableRLSD"] != null && managementObject.Properties["SettableRLSD"].Value != null)
                portInfo.SettableRLSD = (bool?)managementObject.Properties["SettableRLSD"].Value;

            if (managementObject.Properties["SettableStopBits"] != null && managementObject.Properties["SettableStopBits"].Value != null)
                portInfo.SettableStopBits = (bool?)managementObject.Properties["SettableStopBits"].Value;

            if (managementObject.Properties["Supports16BitMode"] != null && managementObject.Properties["Supports16BitMode"].Value != null)
                portInfo.Supports16BitMode = (bool?)managementObject.Properties["Supports16BitMode"].Value;

            if (managementObject.Properties["SupportsDTRDSR"] != null && managementObject.Properties["SupportsDTRDSR"].Value != null)
                portInfo.SupportsDTRDSR = (bool?)managementObject.Properties["SupportsDTRDSR"].Value;

            if (managementObject.Properties["SupportsElapsedTimeouts"] != null && managementObject.Properties["SupportsElapsedTimeouts"].Value != null)
                portInfo.SupportsElapsedTimeouts = (bool?)managementObject.Properties["SupportsElapsedTimeouts"].Value;

            if (managementObject.Properties["SupportsIntTimeouts"] != null && managementObject.Properties["SupportsIntTimeouts"].Value != null)
                portInfo.SupportsIntTimeouts = (bool?)managementObject.Properties["SupportsIntTimeouts"].Value;

            if (managementObject.Properties["SupportsParityCheck"] != null && managementObject.Properties["SupportsParityCheck"].Value != null)
                portInfo.SupportsParityCheck = (bool?)managementObject.Properties["SupportsParityCheck"].Value;

            if (managementObject.Properties["SupportsRLSD"] != null && managementObject.Properties["SupportsRLSD"].Value != null)
                portInfo.SupportsRLSD = (bool?)managementObject.Properties["SupportsRLSD"].Value;

            if (managementObject.Properties["SupportsRTSCTS"] != null && managementObject.Properties["SupportsRTSCTS"].Value != null)
                portInfo.SupportsRTSCTS = (bool?)managementObject.Properties["SupportsRTSCTS"].Value;

            if (managementObject.Properties["SupportsSpecialCharacters"] != null && managementObject.Properties["SupportsSpecialCharacters"].Value != null)
                portInfo.SupportsSpecialCharacters = (bool?)managementObject.Properties["SupportsSpecialCharacters"].Value;

            if (managementObject.Properties["SupportsXOnXOff"] != null && managementObject.Properties["SupportsXOnXOff"].Value != null)
                portInfo.SupportsXOnXOff = (bool?)managementObject.Properties["SupportsXOnXOff"].Value;

            if (managementObject.Properties["SupportsXOnXOffSet"] != null && managementObject.Properties["SupportsXOnXOffSet"].Value != null)
                portInfo.SupportsXOnXOffSet = (bool?)managementObject.Properties["SupportsXOnXOffSet"].Value;

        }
        private static void MapObject2Win32PnPEntityClass(ManagementObject managementObject, Win32PnPEntityClass portInfo)
        {
            MapObject2BaseWin32DeviceClass(managementObject, portInfo);
            if (managementObject.Properties["ClassGuid"] != null && managementObject.Properties["ClassGuid"].Value != null)
                portInfo.ClassGuid = (string)managementObject.Properties["ClassGuid"].Value;
            if (managementObject.Properties["ErrorCleared"] != null && managementObject.Properties["ErrorCleared"].Value != null)
                portInfo.ErrorCleared = (bool?)managementObject.Properties["ErrorCleared"].Value;
            if (managementObject.Properties["ErrorDescription"] != null && managementObject.Properties["ErrorDescription"].Value != null)
                portInfo.ErrorDescription = (string)managementObject.Properties["ErrorDescription"].Value;
            if (managementObject.Properties["InstallDate"] != null && managementObject.Properties["InstallDate"].Value != null)
                portInfo.InstallDate = (DateTime?)managementObject.Properties["InstallDate"].Value;
            if (managementObject.Properties["LastErrorCode"] != null && managementObject.Properties["LastErrorCode"].Value != null)
                portInfo.LastErrorCode = (int?)managementObject.Properties["LastErrorCode"].Value;
            if (managementObject.Properties["Manufacturer"] != null && managementObject.Properties["Manufacturer"].Value != null)
                portInfo.Manufacturer = (string)managementObject.Properties["Manufacturer"].Value;
            if (managementObject.Properties["Service"] != null && managementObject.Properties["Service"].Value != null)
                portInfo.Service = (string)managementObject.Properties["Service"].Value;

            if (!String.IsNullOrEmpty(portInfo.Caption))
            {
                foreach (string s in serialPortNames)
                {
                    if (portInfo.Caption.Contains("(" + s + ")"))
                    {
                        portInfo.DeviceID = s;
                    }
                }
            }
        }
        #endregion
    }
}

