using System;
using System.Collections.Generic;
using System.Text;
using Zensys.Framework;

namespace Zensys.ZWave.ZWaveHAL
{
    public class StoragePerPort
    {
        SortedList<string, byte[]> mList = new SortedList<string, byte[]>();
        internal StoragePerPort(byte[] buffer)
        {
            if (buffer != null)
            {
                Parse(buffer, 0);
            }
        }

        Encoding encoding = Encoding.UTF8;
        private void Parse(byte[] buffer, int index)
        {
            if (buffer.Length > index)
            {
                byte nameLength = buffer[index];
                if (buffer.Length >= index + 1 + nameLength + 2)
                {
                    string name = encoding.GetString(buffer, index + 1, nameLength);
                    short valueLength = BitConverter.ToInt16(buffer, index + 1 + nameLength);
                    if (buffer.Length >= index + 1 + nameLength + 2 + valueLength)
                    {
                        byte[] value = new byte[valueLength];
                        Array.Copy(buffer, index + 1 + nameLength + 2, value, 0, valueLength);
                        mList.Add(name, value);
                        if (buffer.Length > index + 1 + nameLength + 2 + valueLength)
                            Parse(buffer, index + 1 + nameLength + 2 + valueLength);
                    }
                }
            }
        }

        private SortedList<string, byte[]> List
        {
            get { return mList; }
            set { mList = value; }
        }

        private byte[] GetBuffer()
        {
            List<byte> ret = new List<byte>();
            foreach (KeyValuePair<string, byte[]> var in mList)
            {
                ret.Add((byte)encoding.GetByteCount(var.Key));
                ret.AddRange(encoding.GetBytes(var.Key));
                ret.AddRange(BitConverter.GetBytes((short)var.Value.Length));
                ret.AddRange(var.Value);
            }
            return ret.ToArray();
        }

        public static byte[] StoreData(byte[] settingsStorage, string key, byte[] data)
        {
            StoragePerPort spp = new StoragePerPort(null);
            if (settingsStorage != null)
            {
                try
                {
                    spp = new StoragePerPort(settingsStorage);
                    if (spp.List.ContainsKey(key))
                    {
                        spp.List[key] = data;
                    }
                    else
                    {
                        spp.List.Add(key, data);
                    }
                }
                catch (Exception ex)
                {
                    Tools._writeDebugDiagnosticExceptionMessage(ex.Message);
                }
            }
            else
            {
                spp.List.Add(key, data);
            }
            return spp.GetBuffer();
        }

        public static bool GetData(byte[] settingsStorage, string key, ref byte[] data)
        {
            bool ret = false;
            if (settingsStorage != null)
            {
                try
                {
                    StoragePerPort spp = new StoragePerPort(settingsStorage);
                    if (spp.List.ContainsKey(key))
                    {
                        spp.List[key].CopyTo(data, 0);
                        ret = true;
                    }
                }
                catch (Exception ex)
                {
                    Tools._writeDebugDiagnosticExceptionMessage(ex.Message);
                }
            }
            return ret;
        }
    }
}
