using System;
using System.Collections.Generic;
using System.Text;
using System.ComponentModel;
using Zensys.ZWave.Application;
using Zensys.Framework;

namespace Zensys.ZWave.ZWaveHAL
{
    public class ParameterWrapperCollectionPropertyDescriptor : PropertyDescriptor
    {
        private ParameterWrapperCollection collection = null;
        private int index = -1;
        public ParameterWrapperCollectionPropertyDescriptor(ParameterWrapperCollection coll, int idx)
            : base("#" + idx.ToString(), null)
        {
            this.collection = coll;
            this.index = idx;
        }
        public override bool CanResetValue(object component)
        {
            return true;
        }

        public override Type ComponentType
        {
            get
            {
                return this.collection.GetType();
            }
        }

        public override object GetValue(object component)
        {
            ParamValue parameterWrapper = (ParamValue)this.collection[index];
            if (parameterWrapper.ParamValues != null && parameterWrapper.ParamValues.Count > 0)
            {
                return parameterWrapper;
            }
            return parameterWrapper.ByteValueList;
        }

        public override bool IsReadOnly
        {
            get { return false; }
        }

        public override Type PropertyType
        {
            get
            {
                ParamValue parameterWrapper = (ParamValue)this.collection[index];
                if (parameterWrapper.ParamValues != null && parameterWrapper.ParamValues.Count > 0)
                {
                    return typeof(List<ParameterWrapperCollection>);
                }
                return typeof(string);
            }
        }

        public override void ResetValue(object component)
        {

        }

        public override void SetValue(object component, object value)
        {
            ParamValue parameterWrapper = (ParamValue)this.collection[index];
            if (parameterWrapper.ParamDefinition.Param1 != null &&
                parameterWrapper.ParamDefinition.Param1.Count > 0)
            {
                if (parameterWrapper.ParamValues == null || parameterWrapper.ParamValues.Count == 0)
                {
                    parameterWrapper.ParamValues = new List<ParamValue>();
                    ParamValue pv = ParamValue.CreateParamValue(parameterWrapper.ParamDefinition);
                    pv.ParamValues = new List<ParamValue>();
                    foreach (Param p in pv.ParamDefinition.Param1)
                    {
                        pv.ParamValues.Add(ParamValue.CreateParamValue(p));
                    }
                    parameterWrapper.ParamValues.Add(pv);
                }
            }
            else
            {
                if (parameterWrapper.ParamDefinition.SizeReference == null &&
                    parameterWrapper.ParamDefinition.Bits > 8)
                {
                    int byteCount = parameterWrapper.ParamDefinition.Bits / 8;
                    if (parameterWrapper.ParamDefinition.Size > 0)
                    {
                        byteCount = byteCount * parameterWrapper.ParamDefinition.Size;
                    }
                    this.collection[index].ByteValueList.Clear();
                    for (int i = 0; i < byteCount; i++)
                    {
                        this.collection[index].ByteValueList.Add(((List<byte>)value)[i]);
                    }
                }
                else if (parameterWrapper.ParamDefinition.SizeReference != null)
                {
                    this.collection[index].ByteValueList = (List<byte>)value;
                }

                else
                {
                    byte _value = 0;
                    List<byte> pValue = (List<byte>)value;
                    if (pValue != null && pValue.Count > 0)
                    {
                        _value = pValue[0];
                    }
                    this.collection[index].ByteValueList.Clear();
                    if (parameterWrapper.ParamDefinition.Bits > 0 && parameterWrapper.ParamDefinition.Bits < 8)
                    {
                        byte maxVal = Tools.GetMaskFromBits(parameterWrapper.ParamDefinition.Bits, 0);
                        if (_value > maxVal)
                            _value = maxVal;
                    }
                    this.collection[index].ByteValueList.Add(_value);
                }

            }
        }

        public override bool ShouldSerializeValue(object component)
        {
            return true;
        }

        public override string DisplayName
        {
            get
            {
                ParamValue parameterWrapper = (ParamValue)this.collection[index];
                if (parameterWrapper.ParamValues != null)
                {
                    return parameterWrapper.ToString() + ", Count:" + parameterWrapper.ParamValues.Count.ToString();
                }
                return parameterWrapper.ToString();
            }
        }

        public override TypeConverter Converter
        {
            get
            {
                return new ByteArrayToStringTypeConverter((ParamValue)this.collection[index]);
            }
        }

        public override object GetEditor(Type editorBaseType)
        {
            object ret = base.GetEditor(editorBaseType);
            ParamValue parameterWrapper = (ParamValue)this.collection[index];
            if (parameterWrapper.ParamDefinition != null && parameterWrapper.ParamDefinition.Param1 != null)
            {
                ret = new VariantGroupEditor();
            }
            return ret;
        }
    }
}

