using System;
using System.Collections.Generic;
using System.Text;
using System.ComponentModel;
using System.Collections;
using Zensys.ZWave.Application;

namespace Zensys.ZWave.ZWaveHAL
{
    public class ParameterWrapperCollection : CollectionBase, ICustomTypeDescriptor
    {
        public ParameterWrapperCollection()
        {
        }
        public ParameterWrapperCollection(List<ParamValue> arr)
        {
            foreach (ParamValue p in arr)
            {
                this.Add(p);
            }
        }
        public ParameterWrapperCollection(List<ParamValue> arr, string name)
            : this(arr)
        {
            this.Name = name;
        }
        private string mName;
        public string Name
        {
            get { return mName; }
            set { mName = value; }
        }

        #region CollectionBase Implementation

        public void Add(ParamValue parameterWrapper)
        {
            this.List.Add(parameterWrapper);
        }

        public void Remove(ParamValue parameterWrapper)
        {
            this.List.Remove(parameterWrapper);
        }

        public void Sort()
        {
            //this.InnerList.Sort(new ParameterWrapperComparer());
        }

        public ParamValue this[int index]
        {
            get
            {
                return (ParamValue)this.List[index];
            }
        }
        #endregion
        #region ICustomTypeDescriptor Members

        public AttributeCollection GetAttributes()
        {
            return TypeDescriptor.GetAttributes(this, true);
        }

        public string GetClassName()
        {
            return TypeDescriptor.GetClassName(this, true);
        }

        public string GetComponentName()
        {
            return TypeDescriptor.GetComponentName(this, true);
        }

        public TypeConverter GetConverter()
        {
            return TypeDescriptor.GetConverter(this, true);
        }

        public EventDescriptor GetDefaultEvent()
        {
            return TypeDescriptor.GetDefaultEvent(this, true);
        }

        public PropertyDescriptor GetDefaultProperty()
        {
            return TypeDescriptor.GetDefaultProperty(this, true);
        }

        public object GetEditor(Type editorBaseType)
        {
            return TypeDescriptor.GetEditor(this, editorBaseType, true);
        }

        public EventDescriptorCollection GetEvents(Attribute[] attributes)
        {
            return TypeDescriptor.GetEvents(this, attributes, true);
        }

        public EventDescriptorCollection GetEvents()
        {
            return TypeDescriptor.GetEvents(this, true);
        }

        public PropertyDescriptorCollection GetProperties(Attribute[] attributes)
        {
            return GetProperties();
        }

        public PropertyDescriptorCollection GetProperties()
        {
            PropertyDescriptorCollection pds = new PropertyDescriptorCollection(null);
            for (int i = 0; i < this.List.Count; i++)
            {
                ParameterWrapperCollectionPropertyDescriptor pd = new ParameterWrapperCollectionPropertyDescriptor(this, i);
                pds.Add(pd);
            }
            return pds;
        }

        public object GetPropertyOwner(PropertyDescriptor propertyDescriptor)
        {
            return this;
        }

        #endregion

        public List<ParamValue> ToParamValueList()
        {
            List<ParamValue> result = new List<ParamValue>();
            foreach (ParamValue pv in this)
            {
                result.Add(pv);
            }
            return result;
        }
        public override string ToString()
        {
            return this.Name;
        }
    }
}
