using System;
using System.Collections.Generic;
using System.Text;
using System.ComponentModel;
using Zensys.Framework;
using Zensys.ZWave.Application;

namespace Zensys.ZWave.ZWaveHAL
{
    public class ByteArrayToStringTypeConverter : TypeConverter
    {
        ParamValue mParameterWrapper;
        public ByteArrayToStringTypeConverter(ParamValue parameterWrapper)
        {
            mParameterWrapper = parameterWrapper;
        }

        public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType)
        {
            if (sourceType == typeof(string))
            {
                return true;
            }
            return base.CanConvertFrom(context, sourceType);
        }
        public override object ConvertFrom(ITypeDescriptorContext context, System.Globalization.CultureInfo culture, object value)
        {
            if (value is string)
            {
                List<byte> result = new List<byte>();
                try
                {
                    string str = ((string)value).Replace(" ", "");
                    byte[] r = Tools.FromHexString(str);
                    if (r != null)
                    {
                        result = new List<byte>(r);
                    }
                }
                catch
                {

                }

                return result;
            }
            return base.ConvertFrom(context, culture, value);
        }
        public override object ConvertTo(ITypeDescriptorContext context, System.Globalization.CultureInfo culture, object value, Type destinationType)
        {
            if (value != null)
            {
                if (destinationType == typeof(string) && value.GetType().Equals(typeof(List<byte>)))
                {
                    return Tools.ToHexString((List<byte>)value, " ");
                }
            }
            return base.ConvertTo(context, culture, value, destinationType);
        }
    }
}
