using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.Devices;

namespace Zensys.ZWave
{
    /// <summary>
    /// Provides the features required to support scenarios when creating Z-Wave Device classes.
    /// </summary>
    public interface IApplicationLayer
    {
        /// <summary>
        /// Inits instance with the specified session layer.
        /// </summary>
        /// <param name="sessionLayer">The session layer.</param>
        /// <param name="useExternalCommandClassesStorage">if set to <c>true</c> [use external command classes storage].</param>
        void Init(ISessionLayer sessionLayer, bool useExternalCommandClassesStorage);
        /// <summary>
        /// Creates the Controller Device class.
        /// </summary>
        /// <returns></returns>
        IController CreateController();
        /// <summary>
        /// Creates the Controller Device class.
        /// </summary>
        /// <param name="version">The version.</param>
        /// <param name="serialPortName">Name of the serial port.</param>
        /// <returns></returns>
        IController CreateController(VersionInfo version, string serialPortName);
        /// <summary>
        /// Creates the Bridge Controller Device class.
        /// </summary>
        /// <returns></returns>
        IBridgeController CreateBridgeController();
        /// <summary>
        /// Creates the Bridge Controller Device class.
        /// </summary>
        /// <param name="version">The version.</param>
        /// <param name="serialPortName">Name of the serial port.</param>
        /// <returns></returns>
        IBridgeController CreateBridgeController(VersionInfo version, string serialPortName);
        /// <summary>
        /// Creates the Generic Device class.
        /// </summary>
        /// <returns></returns>
        IDevice CreateDevice();
        /// <summary>
        /// Creates the device.
        /// </summary>
        /// <param name="deviceInfo">The device info.</param>
        /// <returns></returns>
        IDevice CreateDevice(IDeviceInfo deviceInfo);
        /// <summary>
        /// Creates the Enhanced Slave Device class.
        /// </summary>
        /// <returns></returns>
        IEnhancedSlave CreateEnhancedSlave();
        /// <summary>
        /// Creates the Enhanced Slave Device class.
        /// </summary>
        /// <param name="version">The version.</param>
        /// <param name="serialPortName">Name of the serial port.</param>
        /// <returns></returns>
        IEnhancedSlave CreateEnhancedSlave(VersionInfo version, string serialPortName);
        /// <summary>
        /// Creates the Installer Controller Device class.
        /// </summary>
        /// <returns></returns>
        IInstallerController CreateInstallerController();
        /// <summary>
        /// Creates the Installer Controller Device class.
        /// </summary>
        /// <param name="version">The version.</param>
        /// <param name="serialPortName">Name of the serial port.</param>
        /// <returns></returns>
        IInstallerController CreateInstallerController(VersionInfo version, string serialPortName);
        /// <summary>
        /// Creates the Routing Slave Device class.
        /// </summary>
        /// <returns></returns>
        IRoutingSlave CreateRoutingSlave();
        /// <summary>
        /// Creates the Routing Slave Device class.
        /// </summary>
        /// <param name="version">The version.</param>
        /// <param name="serialPortName">Name of the serial port.</param>
        /// <returns></returns>
        IRoutingSlave CreateRoutingSlave(VersionInfo version, string serialPortName);
        /// <summary>
        /// Creates the Slave Device class.
        /// </summary>
        /// <returns></returns>
        ISlave CreateSlave();
        /// <summary>
        /// Creates the Slave Device class.
        /// </summary>
        /// <param name="version">The version.</param>
        /// <param name="serialPortName">Name of the serial port.</param>
        /// <returns></returns>
        ISlave CreateSlave(VersionInfo version, string serialPortName);
        /// <summary>
        /// Creates the Static Update Controller Device class.
        /// </summary>
        /// <returns></returns>
        IStaticUpdateController CreateStaticUpdateController();
        /// <summary>
        /// Creates the Static Update Controller Device class.
        /// </summary>
        /// <param name="version">The version.</param>
        /// <param name="serialPortName">Name of the serial port.</param>
        /// <returns></returns>
        IStaticUpdateController CreateStaticUpdateController(VersionInfo version, string serialPortName);
        /// <summary>
        /// Creates the Zensor Net Routing Slave Device class.
        /// </summary>
        /// <returns></returns>
        IZensorNetRoutingSlave CreateZensorNetRoutingSlave();
        /// <summary>
        /// Creates the Zensor Net Routing Slave Device class.
        /// </summary>
        /// <param name="version">The version.</param>
        /// <param name="serialPortName">Name of the serial port.</param>
        /// <returns></returns>
        IZensorNetRoutingSlave CreateZensorNetRoutingSlave(VersionInfo version, string serialPortName);
        /// <summary>
        /// Creates the Flash Settings class.
        /// </summary>
        /// <returns></returns>
        IFlashSettings CreateFlashSettings();
        /// <summary>
        /// Gets or sets a value indicating whether [use external command classes storage].
        /// </summary>
        /// <value>
        /// 	<c>true</c> if [use external command classes storage]; otherwise, <c>false</c>.
        /// </value>
        bool UseExternalCommandClassesStorage { get; set;}
    }
}
