using System;
using System.Collections.Generic;
using System.Text;

namespace Zensys.ZWave.Enums
{
    /// <summary>
    /// Connection Statuses enumeration.
    /// </summary>
    public enum ConnectionStatuses
    {
        /// <summary>
        /// Initial status of <see cref="Zensys.ZWave.Devices.IDevice"></see> connection.
        /// </summary>
        None,
        /// <summary>
        /// <see cref="Zensys.ZWave.Devices.IDevice"></see> conection established.
        /// </summary>
        Opened,
        /// <summary>
        /// <see cref="Zensys.ZWave.Devices.IDevice"></see> connection correctly closed.
        /// </summary>
        Closed,
        /// <summary>
        /// <see cref="Zensys.ZWave.Devices.IDevice"></see> connection lost or invalid.
        /// </summary>
        Invalid,
    }
}
