using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.Enums;

namespace Zensys.ZWave.Devices
{
    /// <summary>
    /// This interface provides methods that allow the client program using Bridge Controller specific Serial API.
    /// </summary>
    public interface IBridgeController : IController
    {
        /// <summary>
        /// Sends the slave data.
        /// </summary>
        /// <param name="sourceId">The source id.</param>
        /// <param name="destinationId">The destination id.</param>
        /// <param name="data">The data.</param>
        /// <param name="txOptions">The tx options.</param>
        /// <returns></returns>
        TransmitStatuses SendSlaveData(byte sourceId, byte destinationId, byte[] data, TransmitOptions txOptions);
        /// <summary>
        /// Sets the slave node information.
        /// </summary>
        /// <param name="nodeId">The node id.</param>
        /// <param name="listening">if set to <c>true</c> [listening].</param>
        /// <param name="generic">The generic.</param>
        /// <param name="specific">The specific.</param>
        /// <param name="nodeParameter">The node parameter.</param>
        void SetSlaveNodeInformation(byte nodeId, bool listening, byte generic, byte specific, byte[] nodeParameter);
        /// <summary>
        /// Sends the slave node information.
        /// </summary>
        /// <param name="sourceId">The source id.</param>
        /// <param name="destinationId">The destination id.</param>
        /// <param name="txOptions">The tx options.</param>
        /// <returns></returns>
        TransmitStatuses SendSlaveNodeInformation(byte sourceId, byte destinationId, TransmitOptions txOptions);
        /// <summary>
        /// Sets the slave learn mode.
        /// </summary>
        /// <param name="nodeId">The node id.</param>
        /// <param name="learnMode">if set to <c>true</c> [learn mode].</param>
        /// <returns></returns>
        byte[] SetSlaveLearnMode(byte nodeId, SlaveLearnMode learnMode);
        /// <summary>
        /// Gets the virtual nodes.
        /// </summary>
        /// <returns></returns>
        NodeMask GetVirtualNodes();
        /// <summary>
        /// Sets the slave learn mode enable and transmit node info.
        /// </summary>
        /// <param name="nodeId">The node id.</param>
        /// <returns>new node id</returns>
        byte SetSlaveLearnModeEnableAndTx(byte nodeId);
    }
}
