using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.Enums;

namespace Zensys.ZWave.Devices
{
    /// <summary>
    /// Represents a collection of Leds in a <see cref="IDevice"/>.
    /// </summary>
    public class DeviceLedCollection : List<IDeviceLed>
    {
        /// <summary>
        /// Gets the item by it type(<see cref="LedTypes"/>).
        /// </summary>
        /// <param name="type">The type.</param>
        /// <returns></returns>
        public IDeviceLed GetByType(LedTypes type)
        {
            IDeviceLed result = null;
            foreach (IDeviceLed led in this)
            {
                if (led.Type == type)
                {
                    result = led;
                    break;
                }
            }
            return result;
        }
    }
}
