using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave;
using Zensys.ZWave.Devices;
using Zensys.ZWave.SerialPortApplication.Devices;
using Zensys.ZWave.Enums;
using System.IO;

namespace Zensys.ZWave.SerialPortApplication
{
    public class ApplicationLayer: IApplicationLayer
    {
        

        ISessionLayer mSessionLayer = null;
        #region IApplicationLayer Members

        /// <summary>
        /// Creates the controller.
        /// </summary>
        /// <returns></returns>
        public IController CreateController()
        {
            Controller ret = new Controller(mSessionLayer, UseExternalCommandClassesStorage);
            return ret;
        }

        /// <summary>
        /// Creates the controller.
        /// </summary>
        /// <param name="version">The version.</param>
        /// <param name="serialPortName">Name of the serial port.</param>
        /// <returns></returns>
        public IController CreateController(VersionInfo version, string serialPortName)
        {
            Controller ret = new Controller(mSessionLayer, UseExternalCommandClassesStorage);
            ret.Version = version;
            ret.SerialPort = serialPortName;
            return ret;
        }

        /// <summary>
        /// Inits the specified session layer.
        /// </summary>
        /// <param name="sessionLayer">The session layer.</param>
        public void Init(ISessionLayer sessionLayer, bool useExternalCommandClassesStorage)
        {
            mSessionLayer = sessionLayer;
            mUseExternalCommandClassesStorage = useExternalCommandClassesStorage;
           
        }

        /// <summary>
        /// Creates the bridge controller.
        /// </summary>
        /// <returns></returns>
        public IBridgeController CreateBridgeController()
        {
            BridgeController ret = new BridgeController(mSessionLayer, UseExternalCommandClassesStorage);
            return ret;
        }

        /// <summary>
        /// Creates the bridge controller.
        /// </summary>
        /// <param name="version">The version.</param>
        /// <param name="serialPortName">Name of the serial port.</param>
        /// <returns></returns>
        public IBridgeController CreateBridgeController(VersionInfo version, string serialPortName)
        {
            BridgeController ret = new BridgeController(mSessionLayer, UseExternalCommandClassesStorage);
            ret.Version = version;
            ret.SerialPort = serialPortName;
            return ret;
        }
         
        /// <summary>
        /// Creates the device.
        /// </summary>
        /// <returns></returns>
        public IDevice CreateDevice()
        {
            Device device = new Device(mSessionLayer);
            device.Leds.Add(new DeviceLed(mSessionLayer, LedTypes.Pass));
            device.Leds.Add(new DeviceLed(mSessionLayer, LedTypes.Error));
            device.Leds.Add(new DeviceLed(mSessionLayer, LedTypes.Busy));
            return device;
        }

        /// <summary>
        /// Creates the device.
        /// </summary>
        /// <returns></returns>
        public IDevice CreateDevice(IDeviceInfo deviceInfo)
        {
            Device device = new Device(mSessionLayer);
            device.Leds.Add(new DeviceLed(mSessionLayer, LedTypes.Pass));
            device.Leds.Add(new DeviceLed(mSessionLayer, LedTypes.Error));
            device.Leds.Add(new DeviceLed(mSessionLayer, LedTypes.Busy));
            device.Basic = deviceInfo.Basic;
            device.Capability = deviceInfo.Capability;
            device.Generic = deviceInfo.Generic;
            device.HomeId = deviceInfo.HomeId;
            device.Id = deviceInfo.Id;
            device.IsSlaveApi = deviceInfo.IsSlaveApi;
            device.IsVirtual = deviceInfo.IsVirtual;
            device.Reserved = deviceInfo.Reserved;
            device.Security = deviceInfo.Security;
            device.Specific = deviceInfo.Specific;
            device.SupportedCommandClasses = deviceInfo.SupportedCommandClasses;
            return device;
        }

        /// <summary>
        /// Creates the enhanced slave.
        /// </summary>
        /// <returns></returns>
        public IEnhancedSlave CreateEnhancedSlave()
        {
            EnhancedSlave device = new EnhancedSlave(mSessionLayer);
            return device;
        }

        /// <summary>
        /// Creates the enhanced slave.
        /// </summary>
        /// <param name="version">The version.</param>
        /// <param name="serialPortName">Name of the serial port.</param>
        /// <returns></returns>
        public IEnhancedSlave CreateEnhancedSlave(VersionInfo version, string serialPortName)
        {
            EnhancedSlave ret = new EnhancedSlave(mSessionLayer);
            ret.Version = version;
            ret.SerialPort = serialPortName;
            return ret;
        }

        /// <summary>
        /// Creates the installer controller.
        /// </summary>
        /// <returns></returns>
        public IInstallerController CreateInstallerController()
        {
            InstallerController ret = new InstallerController(mSessionLayer, UseExternalCommandClassesStorage);
            return ret;
        }

        /// <summary>
        /// Creates the installer controller.
        /// </summary>
        /// <param name="version">The version.</param>
        /// <param name="serialPortName">Name of the serial port.</param>
        /// <returns></returns>
        public IInstallerController CreateInstallerController(VersionInfo version, string serialPortName)
        {
            InstallerController ret = new InstallerController(mSessionLayer, UseExternalCommandClassesStorage);
            ret.Version = version;
            ret.SerialPort = serialPortName;
            return ret;
        }

        /// <summary>
        /// Creates the routing slave.
        /// </summary>
        /// <returns></returns>
        public IRoutingSlave CreateRoutingSlave()
        {
            RoutingSlave ret = new RoutingSlave(mSessionLayer);
            return ret;
        }

        /// <summary>
        /// Creates the routing slave.
        /// </summary>
        /// <param name="version">The version.</param>
        /// <param name="serialPortName">Name of the serial port.</param>
        /// <returns></returns>
        public IRoutingSlave CreateRoutingSlave(VersionInfo version, string serialPortName)
        {
            RoutingSlave ret = new RoutingSlave(mSessionLayer);
            ret.Version = version;
            ret.SerialPort = serialPortName;
            return ret;
        }

        /// <summary>
        /// Creates the slave.
        /// </summary>
        /// <returns></returns>
        public ISlave CreateSlave()
        {
            Slave ret = new Slave(mSessionLayer);
            return ret;
        }

        /// <summary>
        /// Creates the slave.
        /// </summary>
        /// <param name="version">The version.</param>
        /// <param name="serialPortName">Name of the serial port.</param>
        /// <returns></returns>
        public ISlave CreateSlave(VersionInfo version, string serialPortName)
        {
            Slave ret = new Slave(mSessionLayer);
            ret.Version = version;
            ret.SerialPort = serialPortName;
            return ret;
        }

        /// <summary>
        /// Creates the static update controller.
        /// </summary>
        /// <returns></returns>
        public IStaticUpdateController CreateStaticUpdateController()
        {
            StaticUpdateController ret = new StaticUpdateController(mSessionLayer, UseExternalCommandClassesStorage);
            return ret;
        }

        /// <summary>
        /// Creates the static update controller.
        /// </summary>
        /// <param name="version">The version.</param>
        /// <param name="serialPortName">Name of the serial port.</param>
        /// <returns></returns>
        public IStaticUpdateController CreateStaticUpdateController(VersionInfo version, string serialPortName)
        {
            StaticUpdateController ret = new StaticUpdateController(mSessionLayer, UseExternalCommandClassesStorage);
            ret.Version = version;
            ret.SerialPort = serialPortName;
            return ret;
        }

        /// <summary>
        /// Creates the zensor net routing slave.
        /// </summary>
        /// <returns></returns>
        public IZensorNetRoutingSlave CreateZensorNetRoutingSlave()
        {
            ZensorNetRoutingSlave ret = new ZensorNetRoutingSlave(mSessionLayer);
            return ret;
        }

        /// <summary>
        /// Creates the zensor net routing slave.
        /// </summary>
        /// <param name="version">The version.</param>
        /// <param name="serialPortName">Name of the serial port.</param>
        /// <returns></returns>
        public IZensorNetRoutingSlave CreateZensorNetRoutingSlave(VersionInfo version, string serialPortName)
        {
            ZensorNetRoutingSlave ret = new ZensorNetRoutingSlave(mSessionLayer);
            ret.Version = version;
            ret.SerialPort = serialPortName;
            return ret;
        }

        public IFlashSettings CreateFlashSettings()
        {
            return new FlashSettings();
        }

        private bool mUseExternalCommandClassesStorage;
        /// <summary>
        /// Gets or sets a value indicating whether [use external command classes storage].
        /// </summary>
        /// <value>
        /// 	<c>true</c> if [use external command classes storage]; otherwise, <c>false</c>.
        /// </value>
        public bool UseExternalCommandClassesStorage
        {
            get { return mUseExternalCommandClassesStorage; }
            set { mUseExternalCommandClassesStorage = value; }
        }
        #endregion
    }
}
