/*************************************************************************
 * Copyright (c) 2021 by Visuality Systems, Ltd.
 *
 *                     All Rights Reserved
 *
 * This item is the property of Visuality Systems, Ltd., and contains
 * confidential, proprietary, and trade-secret information. It may not
 * be transferred from the custody or control of Visuality Systems, Ltd.,
 * except as expressly authorized in writing by an officer of Visuality
 * Systems, Ltd. Neither this item nor the information it contains may
 * be used, transferred, reproduced, published, or disclosed, in whole
 * or in part, and directly or indirectly, except as expressly authorized
 * by an officer of Visuality Systems, Ltd., pursuant to written agreement.
 *
 *************************************************************************
 * FILE NAME     : $Workfile:$
 * ID            : $Header:$
 * REVISION      : $Revision:$
 *--------------------------------------------------------------------
 * DESCRIPTION   : System epoll operations
 *--------------------------------------------------------------------
 * MODULE        : Linux - SY
 * DEPENDENCIES  :
 *************************************************************************/

#include "syepoll.h"

#ifdef SY_EPOLL_AVAILABLE
#include <sys/epoll.h>

/*#define SYEPOLL_DEBUG*/

SYEpollHandle syEpollCreate(NQ_COUNT num)
{
    SYEpollHandle handle;
    handle = epoll_create((int)num);
    return handle;
}

void syEpollDelete(SYEpollHandle handle)
{
    close(handle);
}

void syEpollAddSocket(SYEpollHandle handle, SYSocketHandle sock, void * context)
{
    struct epoll_event e;
#ifdef SYEPOLL_DEBUG
    NQ_INT res;
#endif /* SYEPOLL_DEBUG */

    e.events = EPOLLIN | EPOLLONESHOT; /* | EPOLLET -> Edge-triggered mode to be notified once (default Level-triggered) */
    e.data.ptr = context;
#ifdef SYEPOLL_DEBUG
    res = 
#endif /* SYEPOLL_DEBUG */        
    epoll_ctl(handle, EPOLL_CTL_ADD, sock, &e);
#ifdef SYEPOLL_DEBUG
    if (-1 == res)
    {
        syFprintf(stderr, "[%s:%d][%s()] sock:%d %d %s\n", SY_LOG_FILE, SY_LOG_LINE, SY_LOG_FUNCTION, sock, errno, strerror(errno));
    }
#endif /* SYEPOLL_DEBUG */
}

void syEpollRearmSocket(SYEpollHandle handle, SYSocketHandle sock, void * context)
{
    struct epoll_event e;
#ifdef SYEPOLL_DEBUG
    NQ_INT res;
#endif /* SYEPOLL_DEBUG */

    e.events = EPOLLIN | EPOLLONESHOT; /* | EPOLLET -> Edge-triggered mode to be notified once (default Level-triggered) */
    e.data.ptr = context;
#ifdef SYEPOLL_DEBUG
    res = 
#endif /* SYEPOLL_DEBUG */   
    epoll_ctl(handle, EPOLL_CTL_MOD, sock, &e);
#ifdef SYEPOLL_DEBUG
    if (-1 == res)
    {
        syFprintf(stderr, "[%s:%d][%s()] sock:%d %d %s\n", SY_LOG_FILE, SY_LOG_LINE, SY_LOG_FUNCTION, sock, errno, strerror(errno));
    }
#endif /* SYEPOLL_DEBUG */
}

void syEpollRemoveSocket(SYEpollHandle handle, SYSocketHandle sock)
{
    struct epoll_event e;
#ifdef SYEPOLL_DEBUG
    NQ_INT res = 
#endif /* SYEPOLL_DEBUG */   
    epoll_ctl(handle, EPOLL_CTL_DEL, sock, &e);
#ifdef SYEPOLL_DEBUG
    if (-1 == res)
    {
        syFprintf(stderr, "[%s:%d][%s()] sock:%d %d %s\n", SY_LOG_FILE, SY_LOG_LINE, SY_LOG_FUNCTION, sock, errno, strerror(errno));
    }
#endif /* SYEPOLL_DEBUG */
}

NQ_INT syEpollWait(SYEpollHandle handle, void ** context, NQ_UINT32 timeout)
{
    struct epoll_event e;
    int res;

    res = epoll_wait(handle, &e, 1, (int)timeout * 1000);
    if (res == 1)
    {
        *context = e.data.ptr;
    }
#ifdef SYEPOLL_DEBUG
    else
    {
        syFprintf(stderr, "[%s:%d][%s()] %d %s\n", SY_LOG_FILE, SY_LOG_LINE, SY_LOG_FUNCTION, errno, strerror(errno));
    }
#endif /* SYEPOLL_DEBUG */
    return res;
}

#endif /* SY_EPOLL_AVAILABLE */
