/*********************************************************************
 *
 *           Copyright (c) 2021 by Visuality Systems, Ltd.
 *
 *********************************************************************
 * FILE NAME     : $Workfile:$
 * ID            : $Header:$
 * REVISION      : $Revision:$
 *--------------------------------------------------------------------
 * DESCRIPTION   : Starting up NetBIOS Daemon
 *--------------------------------------------------------------------
 * MODULE        : Linux
 * DEPENDENCIES  :
 ********************************************************************/

#include <signal.h>
#include <sys/resource.h>

#include <nsapi.h>
#include <ndapi.h>


static
void
sigHandler(
    int signumber
    )
{
#ifdef UD_ND_INCLUDENBDAEMON
    ndStop();
    nsExitGuard();
#endif
}

int
main(
    int argc,
    char** argv
    )
{
    signal(SIGTERM, &sigHandler);

#ifdef UD_ND_INCLUDENBDAEMON
    /* initialization */
    if (NQ_FAIL == udInit())
    {
        goto Exit;
    }
    if (FALSE == syInit())
    {
        udStop();
        goto Exit;
    }

    /* main function */
    ndStart(NULL);

    /* cleanup */
    udStop();
    syStop();
Exit:
#endif /* UD_ND_INCLUDENBDAEMON */
    return 0;
}

