/*************************************************************************
 * Copyright (c) 2021 by Visuality Systems, Ltd.
 *
 *                     All Rights Reserved
 *
 * This item is the property of Visuality Systems, Ltd., and contains
 * confidential, proprietary, and trade-secret information. It may not
 * be transferred from the custody or control of Visuality Systems, Ltd.,
 * except as expressly authorized in writing by an officer of Visuality
 * Systems, Ltd. Neither this item nor the information it contains may
 * be used, transferred, reproduced, published, or disclosed, in whole
 * or in part, and directly or indirectly, except as expressly authorized
 * by an officer of Visuality Systems, Ltd., pursuant to written agreement.
 *
 *************************************************************************
 * FILE NAME     : $Workfile:$
 * ID            : $Header:$
 * REVISION      : $Revision:$
 *--------------------------------------------------------------------
 * DESCRIPTION   : WS-Discovery (WSD) Client light
 *--------------------------------------------------------------------
 * MODULE        : Service
 * DEPENDENCIES  :
 *************************************************************************/

#ifndef _WSDCLIENT_H_
#define _WSDCLIENT_H_

#define DEVICE_TYPE_PRINTER  0x2
#define DEVICE_TYPE_COMPUTER 0x4
#define DEVICE_TYPE_OTHER    0x6

typedef struct
{
    NQ_UINT   deviceType;    /* device type requested */
    NQ_Uuid   uuid;          /* request uuid */
    NQ_WCHAR  *names;        /* list of names discovered, delimited by semicolon */
    NQ_INT    numNames;      /* number of names in list */
}
WsdClientContext;  /* context used by resolver module */

NQ_BOOL wsdClientStart(void);

void wsdClientShutdown(void);

/* Timeout in milliseconds to wait for responses */
NQ_BOOL wsdClientSetTimeout(NQ_UINT32 milliseconds);

#endif /* _WSDCLIENT_H_ */
