/*********************************************************************
 *
 *           Copyright (c) 2021 by Visuality Systems, Ltd.
 *
 *********************************************************************
 * FILE NAME     : $Workfile:$
 * ID            : $Header:$
 * REVISION      : $Revision:$
 *--------------------------------------------------------------------
 * DESCRIPTION   : Validationt in compile-time cross-dependencies
 *--------------------------------------------------------------------
 * MODULE        : Common
 * DEPENDENCIES  :
 ********************************************************************/

#ifndef _CMVALIDA_H_
#define _CMVALIDA_H_

/* network transport dependencies */

#if !defined(UD_NQ_USETRANSPORTNETBIOS) && !defined(UD_NQ_USETRANSPORTIPV4) && !defined(UD_NQ_USETRANSPORTIPV6)
#error No transports defined
#endif

#if !defined(UD_NQ_USETRANSPORTNETBIOS) && defined(UD_ND_INCLUDENBDAEMON)
#error UD_ND_INCLUDENBDAEMON requires UD_NQ_USETRANSPORTNETBIOS
#endif

#if !defined(UD_NQ_USETRANSPORTNETBIOS) && defined(UD_NB_INCLUDENAMESERVICE)
#error UD_NB_INCLUDENAMESERVICE requires UD_NQ_USETRANSPORTNETBIOS
#endif

#if !defined(UD_NQ_USETRANSPORTNETBIOS) && defined(UD_CS_INCLUDEHOSTANNOUNCEMENT)
#error UD_CS_INCLUDEHOSTANNOUNCEMENT requires UD_NQ_USETRANSPORTNETBIOS
#endif

#if !defined(UD_NQ_USETRANSPORTNETBIOS) && defined(UD_NQ_AVOIDDCRESOLUTIONNETBIOS)
#error UD_NQ_AVOIDDCRESOLUTIONNETBIOS requires UD_NQ_USETRANSPORTNETBIOS
#endif

/* sockets dependencies */

#if !defined(UD_NQ_TCPSOCKETRECVTIMEOUT)
#error UD_NQ_TCPSOCKETRECVTIMEOUT must be defined
#endif

/* code page dependencies */

#if (defined(UD_NQ_CODEPAGE437) && !defined(UD_NQ_INCLUDECODEPAGE))
#error UD_NQ_CODEPAGE437 requires UD_NQ_INCLUDECODEPAGE
#endif
#if (defined(UD_NQ_CODEPAGE932) && !defined(UD_NQ_INCLUDECODEPAGE))
#error UD_NQ_CODEPAGE932 requires UD_NQ_INCLUDECODEPAGE
#endif
#if (defined(UD_NQ_CODEPAGE862) && !defined(UD_NQ_INCLUDECODEPAGE))
#error UD_NQ_CODEPAGE862 requires UD_NQ_INCLUDECODEPAGE
#endif
#if (defined(UD_NQ_CODEPAGE850) && !defined(UD_NQ_INCLUDECODEPAGE))
#error UD_NQ_CODEPAGE850 requires UD_NQ_INCLUDECODEPAGE
#endif
#if (defined(UD_NQ_CODEPAGE852) && !defined(UD_NQ_INCLUDECODEPAGE))
#error UD_NQ_CODEPAGE852 requires UD_NQ_INCLUDECODEPAGE
#endif
#if (defined(UD_NQ_CODEPAGE858) && !defined(UD_NQ_INCLUDECODEPAGE))
#error UD_NQ_CODEPAGE858 requires UD_NQ_INCLUDECODEPAGE
#endif
#if (defined(UD_NQ_CODEPAGE936) && !defined(UD_NQ_INCLUDECODEPAGE))
#error UD_NQ_CODEPAGE936 requires UD_NQ_INCLUDECODEPAGE
#endif
#if (defined(UD_NQ_CODEPAGE950) && !defined(UD_NQ_INCLUDECODEPAGE))
#error UD_NQ_CODEPAGE950 requires UD_NQ_INCLUDECODEPAGE
#endif
#if (defined(UD_NQ_CODEPAGE949) && !defined(UD_NQ_INCLUDECODEPAGE))
#error UD_NQ_CODEPAGE949 requires UD_NQ_INCLUDECODEPAGE
#endif
#if (defined(UD_NQ_CODEPAGEUTF8) && !defined(UD_NQ_INCLUDECODEPAGE))
#error UD_NQ_CODEPAGEUTF8 requires UD_NQ_INCLUDECODEPAGE
#endif
#if (defined(UD_NQ_INCLUDECODEPAGE) && !defined(UD_NQ_CODEPAGE437))
#error UD_NQ_INCLUDECODEPAGE requires UD_NQ_CODEPAGE437
#endif

/* NetBIOS functionality */

#if (defined(UD_NB_RETARGETSESSIONS) && !defined(UD_ND_INCLUDENBDAEMON))
#error UD_NB_RETARGETSESSIONS requires UD_ND_INCLUDENBDAEMON
#endif
#if (defined(UD_NB_INCLUDENAMESERVICE) && !defined(UD_ND_INCLUDENBDAEMON))
#error UD_NB_INCLUDENAMESERVICE requires UD_ND_INCLUDENBDAEMON
#endif
#if (defined(UD_NB_CHECKCALLEDNAME) && !defined(UD_ND_INCLUDENBDAEMON))
#error UD_NB_CHECKCALLEDNAME requires UD_ND_INCLUDENBDAEMON
#endif
#if (defined(UD_NB_INCLUDELLMNRRESPONDER) && !defined(UD_ND_INCLUDENBDAEMON))
#error UD_NB_INCLUDELLMNRRESPONDER requires UD_ND_INCLUDENBDAEMON
#endif
#if (defined(UD_NB_INCLUDELLMNRRESPONDER) && !defined(UD_NQ_USETRANSPORTIPV4))
#error UD_NB_INCLUDELLMNRRESPONDER requires UD_NQ_USETRANSPORTIPV4
#endif
#if !defined(UD_NQ_USETRANSPORTNETBIOS) && defined(UD_CM_DONOTREGISTERHOSTNAMENETBIOS)
#error UD_CM_DONOTREGISTERHOSTNAMENETBIOS requires UD_NQ_USETRANSPORTNETBIOS
#endif

/* DNS functionality */

#if !defined(UD_NQ_USETRANSPORTIPV4) && !defined(UD_NQ_USETRANSPORTIPV6) && defined(UD_CM_DONOTREGISTERHOSTNAMEDNS)
#error UD_CM_DONOTREGISTERHOSTNAMEDNS requires UD_NQ_USETRANSPORTIPV4 or UD_NQ_USETRANSPORTIPV6
#endif

/* server functionality */

#if (defined(UD_CS_INCLUDEPASSTHROUGH) && !defined(UD_NQ_INCLUDECIFSSERVER))
#error UD_CS_INCLUDEPASSTHROUGH requires UD_NQ_INCLUDECIFSSERVER
#endif
#if (defined(UD_NS_ASYNCSEND) && !defined(UD_NQ_INCLUDECIFSSERVER))
#error UD_NS_ASYNCSEND requires UD_NQ_INCLUDECIFSSERVER
#endif
#if (defined(UD_CS_INCLUDEHOSTANNOUNCEMENT) && !defined(UD_NQ_INCLUDECIFSSERVER))
#error UD_CS_INCLUDEHOSTANNOUNCEMENT requires UD_NQ_INCLUDECIFSSERVER
#endif
#if (defined(UD_FS_READAHEAD) && !defined(UD_NQ_INCLUDECIFSSERVER))
#error UD_FS_READAHEAD requires UD_NQ_INCLUDECIFSSERVER
#endif
#if (defined(UD_CS_INCLUDELOCALUSERMANAGEMENT) && !defined(UD_CS_INCLUDESECURITYDESCRIPTORS))
#error UD_CS_INCLUDELOCALUSERMANAGEMENT requires UD_CS_INCLUDESECURITYDESCRIPTORS
#endif
#if (defined(UD_CS_INCLUDERPC_SAMRPC) && !defined(UD_CS_INCLUDELOCALUSERMANAGEMENT))
#error UD_CS_INCLUDERPC_SAMRPC requires UD_CS_INCLUDELOCALUSERMANAGEMENT
#endif
#if (defined(UD_CS_INCLUDERPC_SAMRPC) && !defined(UD_CS_INCLUDERPC_LSARPC))
#error UD_CS_INCLUDERPC_SAMRPC requires UD_CS_INCLUDERPC_LSARPC
#endif
#if (defined(UD_CS_INCLUDERPC_SRVSVC_EXTENSION) && !defined(UD_CS_INCLUDERPC_SRVSVC))
#error UD_CS_INCLUDERPC_SRVSVC_EXTENSION requires UD_CS_INCLUDERPC_SRVSVC
#endif
#if (defined(UD_CS_INCLUDESECURITYDESCRIPTORS) && defined(UD_CS_INCLUDEPASSTHROUGH) && !defined(UD_NQ_INCLUDECIFSCLIENT))
#error UD_CS_INCLUDESECURITYDESCRIPTORS and UD_CS_INCLUDEPASSTHROUGH require UD_NQ_INCLUDECIFSCLIENT
#endif
#if (defined(UD_NQ_INCLUDESMB2) && defined(UD_NS_BUFFERSIZE) && UD_NS_BUFFERSIZE < (65700))
#error UD_NS_BUFFERSIZE should be at least 65700 when UD_NQ_INCLUDESMB2 is defined
#endif
#if defined(UD_NQ_INCLUDESMB2) && defined(UD_NQ_INCLUDECIFSSERVER) && !defined(UD_CS_INCLUDEEXTENDEDSECURITY)
#error UD_NQ_INCLUDESMB2 with UD_NQ_INCLUDECIFSSERVER requires UD_CS_INCLUDEEXTENDEDSECURITY
#endif
#if (defined(UD_CS_HIDE_NOACCESS_SHARE) && !defined(UD_CS_INCLUDESECURITYDESCRIPTORS))
#error UD_CS_HIDE_NOACCESS_SHARE requires UD_CS_INCLUDESECURITYDESCRIPTORS
#endif
#if (defined(UD_CS_MESSAGESIGNINGPOLICY) && (UD_CS_MESSAGESIGNINGPOLICY != 1 && UD_CS_MESSAGESIGNINGPOLICY != 2))
#error UD_CS_MESSAGESIGNINGPOLICY can take only values 1 or 2  
#endif
#if (defined(UD_CS_INCLUDEDOMAINMEMBERSHIP) && !defined(UD_CC_INCLUDEDOMAINMEMBERSHIP))
#error UD_CS_INCLUDEDOMAINMEMBERSHIP requires UD_CC_INCLUDEDOMAINMEMBERSHIP
#endif
#if (defined(UD_CS_MESSAGESIGNINGPOLICY) && defined(UD_CS_INCLUDEPASSTHROUGH) && !defined(UD_CS_INCLUDEDOMAINMEMBERSHIP))
#error UD_CS_MESSAGESIGNINGPOLICY defined with UD_CS_INCLUDEPASSTHROUGH requires UD_CS_INCLUDEDOMAINMEMBERSHIP
#endif
#if (defined(UD_NQ_INCLUDESMB3) && defined(UD_NQ_INCLUDECIFSSERVER) && !defined(UD_CS_MESSAGESIGNINGPOLICY))
#error UD_NQ_INCLUDESMB3 requires UD_CS_MESSAGESIGNINGPOLICY of at least 1
#endif
#if (defined(UD_NQ_INCLUDECIFSSERVER) && defined(UD_CS_INCLUDEPASSTHROUGH) && !defined(UD_NQ_INCLUDECIFSCLIENT))
#error UD_NQ_INCLUDECIFSSERVER with UD_CS_INCLUDEPASSTHROUGH requires UD_NQ_INCLUDECIFSCLIENT
#endif
#if (defined(UD_CS_INCLUDEPASSTHROUGH) && !defined(UD_CC_INCLUDEDOMAINMEMBERSHIP))
#error UD_CS_INCLUDEPASSTHROUGH requires UD_CC_INCLUDEDOMAINMEMBERSHIP
#endif
#if (defined(UD_CS_INCLUDEPASSTHROUGH) && !defined(UD_CC_INCLUDERPCOVERTCP))
#error UD_CC_INCLUDERPCOVERTCP must be defined for secure passthrough login
#endif
#if (defined(UD_NQ_INCLUDEEXTENDEDEVENTLOG) && !defined(UD_NQ_INCLUDEEVENTLOG))
#error UD_NQ_INCLUDEEXTENDEDEVENTLOG requires UD_NQ_INCLUDEEVENTLOG
#endif
#if (defined(UD_CS_INCLUDEDIRECTTRANSFER) && (UD_CS_MESSAGESIGNINGPOLICY == 2))
#error UD_CS_INCLUDEDIRECTTRANSFER cannot be used with mandatory signing (UD_CS_MESSAGESIGNINGPOLICY == 2)
#endif
#if (defined(UD_CS_SMB2_INCLUDEMULTICREDIT) && !defined(UD_NS_BUFFERSIZE))
#error UD_CS_SMB2_INCLUDEMULTICREDIT requires UD_NS_BUFFERSIZE
#endif
#if (defined(UD_CS_SMB2_INCLUDEMULTICREDIT) && defined(UD_NS_BUFFERSIZE) && (UD_NS_BUFFERSIZE != ((1024 * 1024 + 168))))
#error UD_CS_SMB2_INCLUDEMULTICREDIT requires UD_NS_BUFFERSIZE of 1MB + headers, use value ((1024 * 1024 + 168))
#endif
#if (defined(UD_CS_AUTHENTICATEANONYMOUS) && defined(UD_CS_ANONYMOUSACCESSALLOWED))
#error UD_CS_AUTHENTICATEANONYMOUS is deprecated, use UD_CS_ANONYMOUSACCESSALLOWED instead
#endif
#if (defined(UD_CS_INCLUDECONTROL) && !defined(UD_NQ_INCLUDECIFSSERVER))
#error UD_CS_INCLUDECONTROL requires UD_NQ_INCLUDECIFSSERVER
#endif
#if (!defined(UD_CS_SPOOLSS_PRN_USESPOOLERFILE) && (defined(UD_CS_SPOOLSS_PRN_MAXDISORDEREDPACKETS)) && (UD_CS_SPOOLSS_PRN_MAXDISORDEREDPACKETS < 1))
#error UD_CS_SPOOLSS_PRN_MAXDISORDEREDPACKETS should be at least 1 when UD_CS_SPOOLSS_PRN_USESPOOLERFILE is not defined
#endif

/* RPC configuration */

#if !defined(UD_CS_INCLUDERPC) && defined(UD_NQ_INCLUDECIFSSERVER)
#error Starting from NQ 6.00 the UD_CS_INCLUDERPC definition in server is mandatory
#endif 
#if (defined(UD_CS_INCLUDERPC_SRVSVC) && !defined(UD_CS_INCLUDERPC))
#error UD_CS_INCLUDERPC_SRVSVC requires UD_CS_INCLUDERPC
#endif
#if (defined(UD_CS_INCLUDERPC_WKSSVC) && !defined(UD_CS_INCLUDERPC))
#error UD_CS_INCLUDERPC_WKSSVC requires UD_CS_INCLUDERPC
#endif
#if (defined(UD_CS_INCLUDERPC_SPOOLSS) && !defined(UD_CS_INCLUDERPC))
#error UD_CS_INCLUDERPC_SPOOLSS requires UD_CS_INCLUDERPC
#endif
#if (defined(UD_CS_INCLUDERPC_SPOOLSS) && !defined(UD_CS_INCLUDESECURITYDESCRIPTORS))
#error UD_CS_INCLUDERPC_SPOOLSS requires UD_CS_INCLUDESECURITYDESCRIPTORS
#endif
#if (defined(UD_CS_INCLUDERPC_LSARPC) && !defined(UD_CS_INCLUDERPC))
#error UD_CS_INCLUDERPC_LSARPC requires UD_CS_INCLUDERPC
#endif
#if (defined(UD_CS_INCLUDERPC_WINREG) && !defined(UD_CS_INCLUDERPC))
#error UD_CS_INCLUDERPC_WINREG requires UD_CS_INCLUDERPC
#endif
#if (defined(UD_CS_INCLUDERPC) && !defined(UD_NQ_INCLUDECIFSSERVER))
#error UD_CS_INCLUDERPC requires UD_NQ_INCLUDECIFSSERVER
#endif

/* client functionality */

#if (defined(UD_CC_INCLUDEDFS) && !defined(UD_NQ_INCLUDECIFSCLIENT))
#error UD_CC_INCLUDEDFS requires UD_NQ_INCLUDECIFSCLIENT
#endif
#if (defined(UD_CC_INCLUDESECURITYDESCRIPTORS) && !defined(UD_NQ_INCLUDECIFSCLIENT))
#error UD_CC_INCLUDESECURITYDESCRIPTORS requires UD_NQ_INCLUDECIFSCLIENT
#endif
#if (defined(UD_CC_INCLUDEDOMAINMEMBERSHIP) && !defined(UD_NQ_INCLUDECIFSCLIENT))
#error UD_CC_INCLUDEDOMAINMEMBERSHIP requires UD_NQ_INCLUDECIFSCLIENT
#endif
#if (defined(UD_NQ_INCLUDECIFSCLIENT) && !defined(UD_CC_CLIENTRESPONSETIMEOUT))
#error UD_NQ_INCLUDECIFSCLIENT requires UD_CC_CLIENTRESPONSETIMEOUT
#endif
#if (defined(UD_CC_INCLUDEEXTENDEDSECURITY_KERBEROS) && !defined(UD_CC_INCLUDEEXTENDEDSECURITY))
#error UD_CC_INCLUDEEXTENDEDSECURITY_KERBEROS requires UD_CC_INCLUDEEXTENDEDSECURITY
#endif
#if (!defined(UD_NQ_INCLUDESMB1) && !defined(UD_NQ_INCLUDESMB2))
#error UD_NQ_INCLUDESMB1 or UD_NQ_INCLUDESMB2 must be defined
#endif
#if (defined(UD_NQ_INCLUDESMB2) && defined(UD_NQ_INCLUDECIFSCLIENT) && !defined(UD_CC_INCLUDEEXTENDEDSECURITY))
#error UD_NQ_INCLUDESMB2 with UD_NQ_INCLUDECIFSCLIENT requires UD_CC_INCLUDEEXTENDEDSECURITY
#endif
#if (defined(UD_CC_INCLUDERPC) && !defined(UD_NQ_INCLUDECIFSCLIENT))
#error UD_CC_INCLUDERPC requires UD_NQ_INCLUDECIFSCLIENT
#endif
#if (defined(UD_CC_RPCDISABLECONNECTIONFALLBACKS) && !defined(UD_CC_INCLUDERPC))
#error UD_CC_RPCDISABLECONNECTIONFALLBACKS requires UD_CC_INCLUDERPC
#endif
#if (defined(UD_CC_INCLUDEBROWSING) && !defined(UD_CC_INCLUDERPC))
#error UD_CC_INCLUDEBROWSING requires UD_CC_INCLUDERPC
#endif
#if (defined(UD_CC_INCLUDERPCOVERTCP) && !defined(UD_CC_INCLUDERPC))
#error UD_CC_INCLUDERPCOVERTCP requires UD_CC_INCLUDERPC
#endif
#if (defined(UD_NQ_INCLUDECIFSCLIENT) && defined(UD_CC_INCLUDELDAP) && !defined(UD_CC_INCLUDEEXTENDEDSECURITY_KERBEROS))
#error UD_CC_INCLUDELDAP requires UD_CC_INCLUDEEXTENDEDSECURITY_KERBEROS
#endif

/* common */

#if (defined(UD_NQ_INCLUDESMB3) && !defined(UD_NQ_INCLUDESMB2))
#error UD_NQ_INCLUDESMB3 requires UD_NQ_INCLUDESMB2
#endif
#if (defined(UD_NQ_INCLUDESMB311) && !defined(UD_NQ_INCLUDESMB3))
#error UD_NQ_INCLUDESMB311 requires UD_NQ_INCLUDESMB3
#endif

#if (defined(UD_CS_INCLUDESECURITYDESCRIPTORS) && !defined(UD_CM_SECURITYDESCRIPTORLENGTH))
#error UD_CS_INCLUDESECURITYDESCRIPTORS Requires UD_CM_SECURITYDESCRIPTORLENGTH
#endif
#if (defined(UD_CC_INCLUDESECURITYDESCRIPTORS) && !defined(UD_CM_SECURITYDESCRIPTORLENGTH))
#error UD_CC_INCLUDESECURITYDESCRIPTORS Requires UD_CM_SECURITYDESCRIPTORLENGTH
#endif
#if (defined (UD_CC_INCLUDEDOMAINMEMBERSHIP) && !defined(UD_CM_SECURITYDESCRIPTORLENGTH))
#error UD_CC_INCLUDEDOMAINMEMBERSHIP Requires UD_CM_SECURITYDESCRIPTORLENGTH
#endif
#if (defined(UD_CS_INCLUDEPASSTHROUGH) && !defined(UD_CM_SECURITYDESCRIPTORLENGTH))
#error UD_CS_INCLUDEPASSTHROUGH Requires UD_CM_SECURITYDESCRIPTORLENGTH
#endif

#if (defined(UD_CM_INCLUDEWSDCLIENT) && !defined(UD_NQ_USETRANSPORTIPV4) && !defined(UD_NQ_USETRANSPORTIPV6))
#error UD_CM_INCLUDEWSDCLIENT Requires UD_NQ_USETRANSPORTIPV4 or UD_NQ_USETRANSPORTIPV6
#endif

#if !defined(CM_NQ_STORAGE)
#define UD_NQ_DYNAMICALLOCATION
#endif

#if defined(UD_NQ_EXTERNALTRACE) && !defined(UD_NQ_INCLUDETRACE)
#error UD_NQ_EXTERNALTRACE Requires UD_NQ_INCLUDETRACE
#endif /* defined(UD_NQ_EXTERNALTRACE) && !defined(UD_NQ_INCLUDETRACE) */

#if defined(UD_NB_CHECKCALLEDNAME_NOIP) && !defined(UD_NB_CHECKCALLEDNAME)
#error UD_NB_CHECKCALLEDNAME_NOIP Requires UD_NB_CHECKCALLEDNAME
#endif

#endif /* _CMVALIDA_H_ */
