/*********************************************************************
 *
 *           Copyright (c) 2021 by Visuality Systems, Ltd.
 *
 *********************************************************************
 * FILE NAME     : $Workfile:$
 * ID            : $Header:$
 * REVISION      : $Revision:$
 *--------------------------------------------------------------------
 * DESCRIPTION   : Common functionality
 *--------------------------------------------------------------------
 * MODULE        : Common
 * DEPENDENCIES  :
 ********************************************************************/

#ifndef _CMUTILS_H_
#define _CMUTILS_H_

typedef char NQ_SCHAR;
typedef unsigned char NQ_SBYTE;

#ifdef SY_COMPILERPACK

/* integer values for initialization */
#define cmPack16(_val) ( _val )
#define cmPack32(_val) ( _val )

/* 16-bit and 32-bit types for use in non-aligned structures */
typedef unsigned short NQ_SUINT16;
#ifdef SY_INT32
typedef unsigned SY_INT32 NQ_SUINT32;
#else /* SY_INT32 */
typedef unsigned long NQ_SUINT32;
#endif /* SY_INT32 */

#define ALLIGN_4BYTE(_data) (((_data)+(0x03))&~(0x03))

#define ADD_ALIGNMENT(_len, _align)     (_len % _align ? (_align - (_len % _align)) : 0)

/* macro to insert magic number to identify memory overruns
 * INPUT must be 'NQ_BYTE *'  */
#define INSERT_MAGIC(_data) *((NQ_UINT32 *)_data) = 0xaaaaaaaa; \
                    _data += sizeof(NQ_UINT32);

/* access to aligned words and longs */
#define cmGetSUint16(_a)      (_a)
#define cmGetSUint32(_a)      (_a)
#define cmPutSUint16(_a, _v)  ((_a) = (NQ_SUINT16)(_v))
#define cmPutSUint32(_a, _v)  ((_a) = (NQ_SUINT32)(_v))

/* Beginning of packed structures definition */

#include "sypackon.h"

typedef SY_PACK_PREFIX struct
{
    NQ_SUINT16 value;
} SY_PACK_ATTR
OddUint16;
typedef SY_PACK_PREFIX struct
{
    NQ_SUINT32 value;
} SY_PACK_ATTR
OddUint32;

#include "sypackof.h"

/* End of packed structures definition */

/* access to non-aligned words and longs */


#define cmGetUint16(_a)      (((OddUint16*)(_a))->value)
#define cmGetUint32(_a)      (((OddUint32*)(_a))->value)
#define cmPutUint16(_a, _v)  ((OddUint16*)(_a))->value = _v
#define cmPutUint32(_a, _v)  ((OddUint32*)(_a))->value = _v
#ifndef UD_NQ_USEIOVECS
#define cmIOGetUint16(_to, _ptr) _to = (((OddUint16*)(_ptr))->value)
#define cmIOGetUint32(_to, _ptr) _to = (((OddUint32*)(_ptr))->value)
#define cmIOPutUint16(_ptr, _v)  ((OddUint16*)(_ptr))->value = _v
#define cmIOPutUint32(_ptr, _v)  ((OddUint32*)(_ptr))->value = _v
#else /* UD_NQ_USEIOVECS */
#define cmIOGetUint16(_to, _IOBUF) if(_IOBUF.byteOffset + sizeof(NQ_UINT16) <= _IOBUF.ioBuf->iovec[_IOBUF.segment].iov_len) \
                                       _to = (((OddUint16*)(IOBUF_GETBYTEPTR(_IOBUF)))->value); \
                                   else \
                                   { \
                                       NQ_BYTE flat[4]; \
                                       IOBUF_MEMCPY_V2F((NQ_BYTE*)&flat, _IOBUF, sizeof(NQ_UINT16)); \
                                       _to = (((OddUint16*)(flat))->value); \
                                   }
#define cmIOGetUint32(_to, _IOBUF) if (_IOBUF.byteOffset + sizeof(NQ_UINT32) <= _IOBUF.ioBuf->iovec[_IOBUF.segment].iov_len) \
                                       _to = (((OddUint32*)(IOBUF_GETBYTEPTR(_IOBUF)))->value); \
                                   else \
                                   { \
                                       NQ_BYTE flat[6]; \
                                       IOBUF_MEMCPY_V2F((NQ_BYTE*)&flat, _IOBUF, sizeof(NQ_UINT32)); \
                                       _to = (((OddUint32*)(flat))->value); \
                                   }
#define cmIOPutUint16(_IOBUF, _v) if (_IOBUF.byteOffset + sizeof(NQ_UINT16) <= _IOBUF.ioBuf->iovec[_IOBUF.segment].iov_len) \
                                      ((OddUint16*)(IOBUF_GETBYTEPTR(_IOBUF)))->value = _v; \
                                  else \
                                      IOBUF_MEMCPY_F2V(_IOBUF, (NQ_BYTE*)&_v, sizeof(NQ_UINT16));
#define cmIOPutUint32(_IOBUF, _v)  if (_IOBUF.byteOffset + sizeof(NQ_UINT32) <= _IOBUF.ioBuf->iovec[_IOBUF.segment].iov_len) \
                                       ((OddUint32*)(IOBUF_GETBYTEPTR(_IOBUF)))->value = _v; \
                                   else \
                                   { \
                                       NQ_UINT32 temp = 0; \
                                       ((OddUint32*)(&temp))->value = _v; \
                                       IOBUF_MEMCPY_F2V(_IOBUF, (NQ_BYTE*)&temp, sizeof(NQ_UINT32)); \
                                   }
#endif /* UD_NQ_USEIOVECS */


#else /* SY_COMPILERPACK */

#ifdef SY_BIGENDIANHOST
#define cmPack16(_val) { ((_val>>8)&0xff), ((_val)&0xff)}
#define cmPack32(_val) { ((_val>>24)&0xffL), ((_val>>16)&0xffL), ((_val>>8)&0xffL), ((_val)&0xffL) }
#else /* SY_BIGENDIANHOST */
#define cmPack16(_val) { ((_val)&0xff), ((_val>>8)&0xff)}
#define cmPack32(_val) { ((_val)&0xffL), ((_val>>8)&0xffL), ((_val>>16)&0xffL), ((_val>>24)&0xffL) }
#endif /* SY_BIGENDIANHOST */

/* 16-bit and 32-bit types for use in non-aligned structures */
typedef NQ_BYTE NQ_SUINT16[2];
typedef NQ_BYTE NQ_SUINT32[4];

typedef SY_PACK_PREFIX struct
{
    NQ_SUINT16 value;
} SY_PACK_ATTR
OddUint16;
typedef SY_PACK_PREFIX struct
{
    NQ_SUINT32 value;
} SY_PACK_ATTR
OddUint32;

/* access to aligned words and longs */
#ifdef SY_LITTLEENDIANHOST
#define cmGetSUint16(_a)     (NQ_UINT16)((_a[1]) << 8 | (_a[0]))
#define cmGetSUint32(_a)     (NQ_UINT32)((_a[3]) << 24 | (_a[2]) << 16 | (_a[1]) << 8 | (_a[0]))
#define cmPutSUint16(_a, _v) {NQ_UINT16 _i = (_v); (_a[1]) = (NQ_BYTE)(((_i)>>8)&0xff); (_a[0]) = (NQ_BYTE)((_i)&0xff);}
#define cmPutSUint32(_a, _v) {NQ_UINT32 _i = (_v); (_a[3]) = (NQ_BYTE)(((_i)>>24)&0xff); (_a[2]) = (NQ_BYTE)(((_i)>>16)&0xff); (_a[1]) = (NQ_BYTE)(((_i)>>8)&0xff); (_a[0]) = (NQ_BYTE)((_i)&0xff);}
#else
#define cmGetSUint16(_a)     (NQ_UINT16)((_a[0]) << 8 | (_a[1]))
#define cmGetSUint32(_a)     (NQ_UINT32)((_a[0]) << 24 | (_a[1]) << 16 | (_a[2]) << 8 | (_a[3]))
#define cmPutSUint16(_a, _v) ((_a[0]) = (NQ_BYTE)(((_v)>>8)&0xff), (_a[1]) = (NQ_BYTE)((_v)&0xff))
#define cmPutSUint32(_a, _v) ((_a[0]) = (NQ_BYTE)(((_v)>>24)&0xff), (_a[1]) = (NQ_BYTE)(((_v)>>16)&0xff), (_a[2]) = (NQ_BYTE)(((_v)>>8)&0xff), (_a[3]) = (NQ_BYTE)((_v)&0xff))
#endif

#ifndef UD_NQ_USEIOVECS
#define cmIOGetUint16(_to, _ptr) _to = cmGetSUint16((((OddUint16*)(_ptr))->value))
#define cmIOGetUint32(_to, _ptr) _to = cmGetSUint32((((OddUint32*)(_ptr))->value))
#define cmIOPutUint16(_ptr, _v)  cmPutSUint16(((OddUint16*)(_ptr))->value, _v)
#define cmIOPutUint32(_ptr, _v)  cmPutSUint32(((OddUint32*)(_ptr))->value, _v)
#else
#define cmIOGetUint16(_to, _IOBUF) if(_IOBUF.byteOffset + sizeof(NQ_UINT16) <= _IOBUF.ioBuf->iovec[_IOBUF.segment].iov_len) \
                                       _to = cmGetSUint16((((OddUint16*)(IOBUF_GETBYTEPTR(_IOBUF)))->value)); \
                                   else \
                                   { \
                                       NQ_BYTE flat[4]; \
                                       IOBUF_MEMCPY_V2F((NQ_BYTE*)&flat, _IOBUF, sizeof(NQ_UINT16)); \
                                       _to = cmGetSUint16((((OddUint16*)(flat))->value)); \
                                   }
#define cmIOGetUint32(_to, _IOBUF) if (_IOBUF.byteOffset + sizeof(NQ_UINT32) <= _IOBUF.ioBuf->iovec[_IOBUF.segment].iov_len) \
                                       _to = cmGetSUint32((((OddUint32*)(IOBUF_GETBYTEPTR(_IOBUF)))->value)); \
                                   else \
                                   { \
                                       NQ_BYTE flat[6]; \
                                       IOBUF_MEMCPY_V2F((NQ_BYTE*)&flat, _IOBUF, sizeof(NQ_UINT32)); \
                                        _to = cmGetSUint32((((OddUint32*)(flat))->value)); \
                                   }
#define cmIOPutUint16(_IOBUF, _v) if (_IOBUF.byteOffset + sizeof(NQ_UINT16) <= _IOBUF.ioBuf->iovec[_IOBUF.segment].iov_len) \
                                      cmPutSUint16(((OddUint16*)(IOBUF_GETBYTEPTR(_IOBUF)))->value, _v); \
                                  else \
                                      IOBUF_MEMCPY_F2V(_IOBUF, (NQ_BYTE*)&_v, sizeof(NQ_UINT16));
#define cmIOPutUint32(_IOBUF, _v)  if (_IOBUF.byteOffset + sizeof(NQ_UINT32) <= _IOBUF.ioBuf->iovec[_IOBUF.segment].iov_len) \
                                       cmIOPutUint32(((OddUint32*)(IOBUF_GETBYTEPTR(_IOBUF)))->value, _v); \
                                   else \
                                   { \
                                       NQ_UINT32 temp = 0; \
                                       ((OddUint32*)(&temp))->value = _v; \
                                       IOBUF_MEMCPY_F2V(_IOBUF, (NQ_BYTE*)&temp, sizeof(NQ_UINT32)); \
                                   }
#endif

#define cmGetUint16(_a)      cmGetSUint16(((NQ_BYTE*)(_a)))
#define cmGetUint32(_a)      cmGetSUint32(((NQ_BYTE*)(_a)))
#define cmPutUint16(_a, _v)  cmPutSUint16(((NQ_BYTE*)(_a)), (_v))
#define cmPutUint32(_a, _v)  cmPutSUint32(((NQ_BYTE*)(_a)), (_v))

#endif /* SY_COMPILERPACK */

typedef NQ_SUINT16 NQ_SWCHAR;

/* the most platform-independent way to allign a pointer */

#define cmAllignTwo(_p)     ((NQ_BYTE *)(_p) + (((NQ_ULONG)(_p)) & 1))
#define cmAllignFour(_p)    ((NQ_BYTE *)(_p) +((4 - (((NQ_ULONG)(_p)) & 3)) % 4))
#define cmAllign8(_p)       ((NQ_BYTE *)(_p) +((8 - (((NQ_ULONG)(_p)) & 7)) % 8))
#define cmAllign16(_p)      ((NQ_BYTE *)(_p) +((16 - (((NQ_ULONG)(_p)) & 15)) % 16))
#define cmAllign32(_p)      ((NQ_BYTE *)(_p) +((32 - (((NQ_ULONG)(_p)) & 31)) % 32))
#define cmAllign64(_p)      ((NQ_BYTE *)(_p) +((64 - (((NQ_ULONG)(_p)) & 63)) % 64))

/* converting LITTLE ENDIAN to the host byte order */
#include <sypltfrm.h>
#ifdef SY_LITTLEENDIANHOST

#ifdef SY_BIGENDIANHOST
#error "Both big and little endian defined"
#endif /* SY_BIGENDIANHOST */

#define cmLtoh16(_v)    (_v)
#define cmLtoh32(_v)    (_v)
#define cmHtol16(_v)    (_v)
#define cmHtol32(_v)    (_v)

/* --- Little to Big Endian Conversion --- */
#define cmHtob16(_v)    ((((_v) & 0xFF00) >> 8) | (((_v) & 0x00FF) << 8))
#define cmHtob32(_v)    cmChangeByteOrder32(_v)

#else /* SY_LITTLEENDIANHOST */

#ifndef SY_BIGENDIANHOST
#error "Neither big nor little endian defined"
#endif /* SY_BIGENDIANHOST */

#define cmLtoh16(_v)    ((((_v) & 0xFF00) >> 8) | (((_v) & 0x00FF) << 8))
#define cmLtoh32(_v)    cmChangeByteOrder32(_v)
#define cmHtol16(_v)    ((((_v) & 0xFF00) / 256) | (((_v) & 0x00FF) * 256))
#define cmHtol32(_v)    cmChangeByteOrder32(_v)
/* --- Little to Big Endian Conversion --- */
#define cmHtob16(_v)    (_v)
#define cmHtob32(_v)    (_v)
#endif /* SY_LITTLEENDIANHOST */

#define cmChangeByteOrder32(_v)    ((((_v) & 0xFF000000) >> 24) |  \
                                    (((_v) & 0x00FF0000) >> 8)  |  \
                                    (((_v) & 0x0000FF00) << 8)  |  \
                                    (((_v) & 0x000000FF) << 24)    \
                                   )

#endif  /* _CMUTILS_H_ */
