/*********************************************************************
 *
 *           Copyright (c) 2021 by Visuality Systems, Ltd.
 *
 *********************************************************************
 * FILE NAME     : $Workfile:$
 * ID            : $Header:$
 * REVISION      : $Revision:$
 *--------------------------------------------------------------------
 * DESCRIPTION   : Domain controller discovery library
 *--------------------------------------------------------------------
 * MODULE        : Common
 * DEPENDENCIES  : None
 ********************************************************************/

#ifndef _CMFINDDC_H_
#define _CMFINDDC_H_

/* initialize find DC resources */

NQ_STATUS
cmFindDCInit(
    void
    );
    
/* release find DC resources */

void
cmFindDCExit(
    void
    );
    
/* query default domain (NetBIOS or DNS) for its PDC name and return server name */

NQ_STATUS                           /* NQ_SUCCESS or NQ_FAIL */
cmGetDCName(
    NQ_CHAR* pdc,                   /* PDC name upon return */
    const NQ_CHAR** domainBuffer    /* pointer for domain name (may be NULL) */
    );

/* query given domain (NetBIOS or DNS) for its PDC name and return server name */

NQ_STATUS                          /* NQ_SUCCESS or NQ_FAIL */
cmGetDCNameByDomain(
    const NQ_CHAR *domain,         /* domain name to find PDC for */
    const NQ_WCHAR *dnsList,       /* semicolon delimited list of DNS servers*/
    NQ_CHAR *pdc                   /* PDC name upon return */
    );

/* add to domain-pdc cache */

void
cmDCAddToCache(
        const NQ_WCHAR *domain,    /* domain name  */
        const NQ_WCHAR *pdc        /* PDC name */
        );

#endif /*_CMFINDDC_H_ */
