/*********************************************************************
 *
 *           Copyright (c) 2021 by Visuality Systems, Ltd.
 *
 *********************************************************************
 * FILE NAME     : $Workfile:$
 * ID            : $Header:$
 * REVISION      : $Revision:$
 *--------------------------------------------------------------------
 * DESCRIPTION   : Codepage 862 - Hebrew
 *--------------------------------------------------------------------
 * MODULE        : Common
 * DEPENDENCIES  :
 ********************************************************************/

#include "cmapi.h"
#include "cmcp.h"

#ifdef UD_NQ_CODEPAGE862

const static NQ_WCHAR a2u[0x100] = {
    /* 0.. 0x7F are identical to unicode */
    0x05d0, 0x05d1, 0x05d2, 0x05d3, 0x05d4, 0x05d5, 0x05d6, 0x05d7,
    0x05d8, 0x05d9, 0x05da, 0x05db, 0x05dc, 0x05dd, 0x05de, 0x05df,
    0x05e0, 0x05e1, 0x05e2, 0x05e3, 0x05e4, 0x05e5, 0x05e6, 0x05e7,
    0x05e8, 0x05e9, 0x05ea, 0x00a2, 0x00a3, 0x00a5, 0x20a7, 0x0192,
    0x00e1, 0x00ed, 0x00f3, 0x00fa, 0x00f1, 0x00d1, 0x00aa, 0x00ba,
    0x00bf, 0x2310, 0x00ac, 0x00bd, 0x00bc, 0x00a1, 0x00ab, 0x00bb,
    0x2591, 0x2592, 0x2593, 0x2502, 0x2524, 0x2561, 0x2562, 0x2556,
    0x2555, 0x2563, 0x2551, 0x2557, 0x255d, 0x255c, 0x255b, 0x2510,
    0x2514, 0x2534, 0x252c, 0x251c, 0x2500, 0x253c, 0x255e, 0x255f,
    0x255a, 0x2554, 0x2569, 0x2566, 0x2560, 0x2550, 0x256c, 0x2567,
    0x2568, 0x2564, 0x2565, 0x2559, 0x2558, 0x2552, 0x2553, 0x256b,
    0x256a, 0x2518, 0x250c, 0x2588, 0x2584, 0x258c, 0x2590, 0x2580,
    0x03b1, 0x00df, 0x0393, 0x03c0, 0x03a3, 0x03c3, 0x00b5, 0x03c4,
    0x03a6, 0x0398, 0x03a9, 0x03b4, 0x221e, 0x03c6, 0x03b5, 0x2229,
    0x2261, 0x00b1, 0x2265, 0x2264, 0x2320, 0x2321, 0x00f7, 0x2248,
    0x00b0, 0x2219, 0x00b7, 0x221a, 0x207f, 0x00b2, 0x25a0, 0x00a0
};

const static NQ_WCHAR u2a_00[] = {
/*       0     1     2     3     4     5     6     7     8     9     a     b     c     d     e     f */
/* a */ 0xff, 0xad, 0x9b, 0x9c, 0x00, 0x9d, 0x00, 0x00, 0x00, 0x00, 0xa6, 0xae, 0xaa, 0x00, 0x00, 0x00,
/* b */ 0xf8, 0xf1, 0xfd, 0x00, 0x00, 0xe6, 0x00, 0xfa, 0x00, 0x00, 0xa7, 0xaf, 0xac, 0xab, 0x00, 0xa8,
/* c */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* d */ 0x00, 0xa5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe1,
/* e */ 0x00, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa1, 0x00, 0x00,
/* f */ 0x00, 0xa4, 0x00, 0xa2, 0x00, 0x00, 0x00, 0xf6
};

const static NQ_WCHAR u2a_03[] = {
/*       0     1     2     3     4     5     6     7     8     9     a     b     c     d     e     f */
/* 9 */                   0xe2, 0x00, 0x00, 0x00, 0x00, 0xe9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* a */ 0x00, 0x00, 0x00, 0xe4, 0x00, 0x00, 0xe8, 0x00, 0x00, 0xea, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* b */ 0x00, 0xe0, 0x00, 0x00, 0xeb, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* c */ 0xe3, 0x00, 0x00, 0xe5, 0xe7, 0x00, 0xed
};

const static NQ_WCHAR u2a_05[] = {
/*       0     1     2     3     4     5     6     7     8     9     a     b     c     d     e     f */
/* d */ 0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f,
/* e */ 0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9a
};

const static NQ_WCHAR u2a_22[] = {
/*       0     1     2     3     4     5     6     7     8     9     a     b     c     d     e     f */
/* 1 */                                                       0xf9, 0xfb, 0x00, 0x00, 0x00, 0xec, 0x00,
/* 2 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xef, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 3 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 4 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 5 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 6 */ 0x00, 0xf0, 0x00, 0x00, 0xf3, 0xf2
};

const static NQ_WCHAR u2a_25[] = {
/*       0     1     2     3     4     5     6     7     8     9     a     b     c     d     e     f */
/* 0 */ 0xc4, 0x00, 0xb3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xda, 0x00, 0x00, 0x00,
/* 1 */ 0xbf, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0xd9, 0x00, 0x00, 0x00, 0xc3, 0x00, 0x00, 0x00,
/* 2 */ 0x00, 0x00, 0x00, 0x00, 0xb4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc2, 0x00, 0x00, 0x00,
/* 3 */ 0x00, 0x00, 0x00, 0x00, 0xc1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc5, 0x00, 0x00, 0x00,
/* 4 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 5 */ 0xcd, 0xba, 0xd5, 0xd6, 0xc9, 0xb8, 0xb7, 0xbb, 0xd4, 0xd3, 0xc8, 0xbe, 0xbd, 0xbc, 0xc6, 0xc7,
/* 6 */ 0xcc, 0xb5, 0xb6, 0xb9, 0xd1, 0xd2, 0xcb, 0xcf, 0xd0, 0xca, 0xd8, 0xd7, 0xce, 0x00, 0x00, 0x00,
/* 7 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 8 */ 0xdf, 0x00, 0x00, 0x00, 0xdc, 0x00, 0x00, 0x00, 0xdb, 0x00, 0x00, 0x00, 0xdd, 0x00, 0x00, 0x00,
/* 9 */ 0xde, 0xb0, 0xb1, 0xb2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* a */ 0xfe
};

static NQ_INT
cp862UnicodeToAnsi(
    NQ_CHAR* outStr,
    NQ_UINT outLength,
    const NQ_WCHAR* inWStr,
    NQ_UINT inLength
    )
{
    const NQ_WCHAR* pW = inWStr;
    NQ_CHAR* pA = outStr;
    NQ_INT length = 0;
    NQ_UINT inNumOfCharacters;
    NQ_BOOL ignoreInLength = (inLength == CM_IGNORE_LENGTH);
    NQ_BOOL ignoreOutLength = (outLength == CM_IGNORE_LENGTH);

    inNumOfCharacters = inLength / sizeof(NQ_WCHAR);  /* calculate number of characters for source buffer */
    outLength--;                                      /* reserve place for trailing zero */
    if (outStr && inWStr)
    {
        for ( ; *pW && (ignoreInLength || (inNumOfCharacters > 0)) && (ignoreOutLength || (length < outLength)); pA++, pW++, inNumOfCharacters--, length++ )
        {
            /* extract Msb in wStr */
            NQ_BYTE wLsb, wMsb;
            cmSplitUnicode (*pW, &wMsb, &wLsb);

            *pA = 0x00;

            switch (wMsb)
            {
            case 0x00:
                if (wLsb < 0xA0)  *pA = (NQ_CHAR)wLsb;
                else  if (wLsb < 0xf8) *pA = (NQ_CHAR)u2a_00[wLsb-0xA0];
                break;
            case 0x05:
                if (0xd0 <= wLsb && wLsb <= 0xea) *pA = (NQ_CHAR)u2a_05[wLsb-0xd0];
                break;
            case 0x01:
                if (wLsb == 0x92) *pA = (NQ_CHAR)0x9f;
                break;
            case 0x03:
                if (0x93 <= wLsb && wLsb <= 0xc6) *pA = (NQ_CHAR)u2a_03[wLsb-0x93];
                break;
            case 0x22:
                if (0x19 <= wLsb && wLsb <= 0x65) *pA = (NQ_CHAR)u2a_22[wLsb-0x19];
                break;
            case 0x25:
                if (wLsb <= 0xa0) *pA = (NQ_CHAR)u2a_25[wLsb];
                break;
            case 0x20:
                switch(wLsb)
                {
                case 0xa7: *pA = (NQ_CHAR)0x9e; break;
                case 0x7f: *pA = (NQ_CHAR)0xfc;
                }
                break;
            case 0x23:
                switch(wLsb)
                {
                case 0x10: *pA = (NQ_CHAR)0xa9; break;
                case 0x20: *pA = (NQ_CHAR)0xf4; break;
                case 0x21: *pA = (NQ_CHAR)0xf5;
                }
                break;
            }
            if (*pA == 0x00) /* wrong unicode */
                break;
        }
    }
    else
    {
        if (!outStr)
        {
            length = 0;
            goto Exit;
        }
    }

    /* Place trailing zero */
        *pA = '\0';

Exit:
    return length;
}

/*static NQ_INT
cp862AnsiToUnicode(
    NQ_WCHAR* outWStr,
    NQ_UINT outLength,
    const NQ_CHAR* inStr,
    NQ_UINT inLength
    )
{
    return cmCpSingleByteAnsiToUnicode(outWStr, outLength, inStr, inLength, a2u);
}
*/

static NQ_INT
cp862ToUpper(
    NQ_CHAR* dst,
    const NQ_CHAR* src
    )
{
    *dst = syToupper(*src);
    return 1;
}

const static CMCodepage enc862 = {
    UD_NQ_CODEPAGE862,
    cp862UnicodeToAnsi,
    NULL,
    cp862ToUpper,
    NULL,
    NULL,
    a2u
};

const CMCodepage* cmCpInit862(
    void
    )
{
    return &enc862;
}

#endif
