/*********************************************************************
 *
 *           Copyright (c) 2021 by Visuality Systems, Ltd.
 *
 *********************************************************************
 * FILE NAME     : $Workfile:$
 * ID            : $Header:$
 * REVISION      : $Revision:$
 *--------------------------------------------------------------------
 * DESCRIPTION   : Codepage 852 - Latin II
 *--------------------------------------------------------------------
 * MODULE        : Common
 * DEPENDENCIES  :
 ********************************************************************/

#include "cmapi.h"
#include "cmcp.h"

#ifdef UD_NQ_CODEPAGE852

const static NQ_WCHAR a2u[0x100] = {
    /* 0.. 0x7F are identical to unicode */
    0x00c7, 0x00fc, 0x00e9, 0x00e2, 0x00e4, 0x016f, 0x0107, 0x00e7,
    0x0142, 0x00eb, 0x0150, 0x0151, 0x00ee, 0x0179, 0x00c4, 0x0106,
    0x00c9, 0x0139, 0x013a, 0x00f4, 0x00f6, 0x013d, 0x013e, 0x015a,
    0x015b, 0x00d6, 0x00dc, 0x0164, 0x0165, 0x0141, 0x00d7, 0x010d,
    0x00e1, 0x00ed, 0x00f3, 0x00fa, 0x0104, 0x0105, 0x017d, 0x017e,
    0x0118, 0x0119, 0x00ac, 0x017a, 0x010c, 0x015f, 0x00ab, 0x00bb,
    0x2591, 0x2592, 0x2593, 0x2502, 0x2524, 0x00c1, 0x00c2, 0x011a,
    0x015e, 0x2563, 0x2551, 0x2557, 0x255d, 0x017b, 0x017c, 0x2510,
    0x2514, 0x2534, 0x252c, 0x251c, 0x2500, 0x253c, 0x0102, 0x0103,
    0x255a, 0x2554, 0x2569, 0x2566, 0x2560, 0x2550, 0x256c, 0x00a4,
    0x0111, 0x0110, 0x010e, 0x00cb, 0x010f, 0x0147, 0x00cd, 0x00ce,
    0x011b, 0x2518, 0x250c, 0x2588, 0x2584, 0x0162, 0x016e, 0x2580,
    0x00d3, 0x00df, 0x00d4, 0x0143, 0x0144, 0x0148, 0x0160, 0x0161,
    0x0154, 0x00da, 0x0155, 0x0170, 0x00fd, 0x00dd, 0x0163, 0x00b4,
    0x00ad, 0x02dd, 0x02db, 0x02c7, 0x02d8, 0x00a7, 0x00f7, 0x00b8,
    0x00b0, 0x00a8, 0x02d9, 0x0171, 0x0158, 0x0159, 0x25a0, 0x00a0
    };

static const NQ_WCHAR u2a_00[] = {
    /*       0     1     2     3     4     5     6     7     8     9     a     b     c     d     e     f */
    /* a */
    0xff, 0x00, 0x00, 0x00, 0xcf, 0x00, 0x00, 0xf5, 0xf9, 0x00, 0x00, 0xae, 0xaa, 0xf0, 0x00, 0x00,
    /* b */
    0xf8, 0x00, 0x00, 0x00, 0xef, 0x00, 0x00, 0x00, 0xf7, 0x00, 0x00, 0xaf, 0x00, 0x00, 0x00, 0x00,
    /* c */
    0x00, 0xb5, 0xb6, 0x00, 0x8e, 0x00, 0x00, 0x80, 0x00, 0x90, 0x00, 0xd3, 0x00, 0xd6, 0xd7, 0x00,
    /* d */
    0x00, 0x00, 0x00, 0xe0, 0xe2, 0x00, 0x99, 0x9e, 0x00, 0x00, 0xe9, 0x00, 0x9a, 0xed, 0x00, 0xe1,
    /* e */
    0x00, 0xa0, 0x83, 0x00, 0x84, 0x00, 0x00, 0x87, 0x00, 0x82, 0x00, 0x89, 0x00, 0xa1, 0x8c, 0x00,
    /* f */
    0x00, 0x00, 0x00, 0xa2, 0x93, 0x00, 0x94, 0xf6, 0x00, 0x00, 0xa3, 0x00, 0x81, 0xec
    };
static const NQ_WCHAR u2a_01[] = {
    /*       0     1     2     3     4     5     6     7     8     9     a     b     c     d     e     f */
    /* 0 */
    0xc6, 0xc7, 0xa4, 0xa5, 0x8f, 0x86, 0x00, 0x00, 0x00, 0x00, 0xac, 0x9f, 0xd2, 0xd4,
    /* 1 */
    0xd1, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xa9, 0xb7, 0xd8, 0x00, 0x00, 0x00, 0x00,
    /* 2 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    /* 3 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x91, 0x92, 0x00, 0x00, 0x95, 0x96, 0x00,
    /* 4 */
    0x00, 0x9d, 0x88, 0xe3, 0xe4, 0x00, 0x00, 0xd5, 0xe5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    /* 5 */
    0x8a, 0x8b, 0x00, 0x00, 0xe8, 0xea, 0x00, 0x00, 0xfc, 0xfd, 0x97, 0x98, 0x00, 0x00, 0xb8, 0xad,
    /* 6 */
    0xe6, 0xe7, 0xdd, 0xee, 0x9b, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xde, 0x85,
    /* 7 */
    0xeb, 0xfb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8d, 0xab, 0xbd, 0xbe, 0xa6, 0xa7
    };
static const NQ_WCHAR u2a_02[] = {
    /*       0     1     2     3     4     5     6     7     8     9     a     b     c     d     e     f */
    /* c */
    0xf3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    /* d */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf4, 0xfa, 0x00, 0xf2, 0x00, 0xf1
    };
static const NQ_WCHAR u2a_25[] = {
    /*       0     1     2     3     4     5     6     7     8     9     a     b     c     d     e     f */
    /* 0 */
    0xc4, 0x00, 0xb3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xda, 0x00, 0x00, 0x00,
    /* 1 */
    0xbf, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0xd9, 0x00, 0x00, 0x00, 0xc3, 0x00, 0x00, 0x00,
    /* 2 */
    0x00, 0x00, 0x00, 0x00, 0xb4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc2, 0x00, 0x00, 0x00,
    /* 3 */
    0x00, 0x00, 0x00, 0x00, 0xc1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc5, 0x00, 0x00, 0x00,
    /* 4 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    /* 5 */
    0xcd, 0xba, 0x00, 0x00, 0xc9, 0x00, 0x00, 0xbb, 0x00, 0x00, 0xc8, 0x00, 0x00, 0xbc, 0x00, 0x00,
    /* 6 */
    0xcc, 0x00, 0x00, 0xb9, 0x00, 0x00, 0xcb, 0x00, 0x00, 0xca, 0x00, 0x00, 0xce, 0x00, 0x00, 0x00,
    /* 7 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    /* 8 */
    0xdf, 0x00, 0x00, 0x00, 0xdc, 0x00, 0x00, 0x00, 0xdb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    /* 9 */
    0x00, 0xb0, 0xb1, 0xb2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    /* a */
    0xfe
    };

static NQ_INT
cp852UnicodeToAnsi(
    NQ_CHAR* outStr,
    NQ_UINT outLength,
    const NQ_WCHAR* inWStr,
    NQ_UINT inLength
    )
{
    const NQ_WCHAR* pW = inWStr;
    NQ_CHAR* pA = outStr;
    NQ_INT length = 0;
    NQ_UINT inNumOfCharacters;
    NQ_BOOL ignoreInLength = (inLength == CM_IGNORE_LENGTH);
    NQ_BOOL ignoreOutLength = (outLength == CM_IGNORE_LENGTH);

    inNumOfCharacters = inLength / sizeof(NQ_WCHAR);  /* calculate number of characters for source buffer */
    outLength--;                                      /* reserve place for trailing zero */
    if (outStr && inWStr)
    {
        for ( ; *pW && (ignoreInLength || (inNumOfCharacters > 0)) && (ignoreOutLength || (length < outLength)); pA++, pW++, inNumOfCharacters--, length++ )
        {
            /* extract Msb in wStr */
            NQ_BYTE wLsb, wMsb;
            cmSplitUnicode (*pW, &wMsb, &wLsb);

            *pA = 0x00;

            switch (wMsb)
            {
                case 0x00:
                    if (wLsb < 0xA0)
                        *pA = (NQ_CHAR)wLsb;
                    else if (wLsb < 0xfe)
                        *pA = (NQ_CHAR)u2a_00[wLsb-0xA0];
                    break;
                case 0x01:
                    if (0x02 <= wLsb && wLsb <= 0x7e)
                        *pA = (NQ_CHAR)u2a_01[wLsb-0x02];
                    break;
                case 0x02:
                    if (0xc7 <= wLsb && wLsb <= 0xdd)
                        *pA = (NQ_CHAR)u2a_02[wLsb-0xc7];
                    break;
                case 0x25:
                    if (wLsb <= 0xa0)
                        *pA = (NQ_CHAR)u2a_25[wLsb];
                    break;
            }
            if (*pA == 0x00) /* wrong unicode */
                break;
        }
    }
    else
    {
        if (!outStr)
        {
            length = 0;
            goto Exit;
        }
    }

    /* Place trailing zero */
    *pA = '\0';

Exit:
    return length;
}
/*
static NQ_INT
cp852AnsiToUnicode(
    NQ_WCHAR* outWStr,
    NQ_UINT outLength,
    const NQ_CHAR* inStr,
    NQ_UINT inLength
    )
{
    return cmCpSingleByteAnsiToUnicode(outWStr, outLength, inStr, inLength, a2u);
}
*/

static NQ_INT
cp852ToUpper(
    NQ_CHAR* dst,
    const NQ_CHAR* src
)
    {
    *dst = syToupper(*src);
    return 1;
    }

const static CMCodepage enc852 = {
    UD_NQ_CODEPAGE852,
    cp852UnicodeToAnsi,
    NULL,
    cp852ToUpper,
    NULL,
    NULL,
    a2u
    };

const CMCodepage* cmCpInit852(
    void
)
    {
    return &enc852;
    }

#endif
