/*********************************************************************
 *
 *           Copyright (c) 2021 by Visuality Systems, Ltd.
 *
 *********************************************************************
 * FILE NAME     : $Workfile:$
 * ID            : $Header:$
 * REVISION      : $Revision:$
 *--------------------------------------------------------------------
 * DESCRIPTION   : Code page module, CP API functions
 *--------------------------------------------------------------------
 * MODULE        : Common
 * DEPENDENCIES  :
 ********************************************************************/

#ifndef _CMCP_H_
#define _CMCP_H_

#ifdef UD_NQ_INCLUDECODEPAGE
#include "cmapi.h"


typedef struct _range {
    NQ_WCHAR start;
    NQ_WCHAR end;
    NQ_WCHAR diff;
} CMCPRange;

NQ_INT
cmCpAnsiToUnicode(
    NQ_WCHAR* wStr,
    NQ_UINT outLength,
    const NQ_CHAR* aStr,
    NQ_UINT inLength
    );

NQ_INT
cmCpUnicodeToAnsi(
    NQ_CHAR* aStr,
    NQ_UINT outLength,
    const NQ_WCHAR* wStr,
    NQ_UINT inLength
    );


NQ_INT
cmCpAToUpper(
    NQ_CHAR* dst,
    const NQ_CHAR* src
    );

NQ_INT
cmCpWToUpper(
    NQ_WCHAR* dst,
    const NQ_WCHAR* src
);

void
cmCpAnsiToFs(
    NQ_CHAR *str,
    NQ_INT size
    );

void
cmCpFsToAnsi(
    NQ_CHAR *str,
    NQ_INT size
    );

NQ_INT
cmCpSingleByteAnsiToUnicode(
    NQ_WCHAR* wStr,
    NQ_UINT outLength,
    const NQ_CHAR* aStr,
    NQ_UINT inLength,
    const NQ_WCHAR* a2uTable
    );

void cmSplitUint16(NQ_WCHAR src, NQ_BYTE *msb, NQ_BYTE *lsb);

void cmSplitUnicode(NQ_WCHAR src, NQ_BYTE *msb, NQ_BYTE *lsb);


#endif /* UD_NQ_INCLUDECODEPAGE */
#endif /* _CMCP_H_ */
