/*********************************************************************
 *
 *           Copyright (c) 2021 by Visuality Systems, Ltd.
 *
 *********************************************************************
 * FILE NAME     : $Workfile:$
 * ID            : $Header:$
 * REVISION      : $Revision:$
 *--------------------------------------------------------------------
 * DESCRIPTION   : RC4 encryption implementation
 *--------------------------------------------------------------------
 * MODULE        : Auth - AM
 * DEPENDENCIES  : None
 ********************************************************************/

#include "cmapi.h"

/*
 *====================================================================
 * PURPOSE: encrypt using ARC4 algorithm
 *--------------------------------------------------------------------
 * PARAMS:  IN/OUT data
 *          IN data length
 *          IN key
 *          IN key length
 *
 * RETURNS: none
 *
 * NOTES:   none
 *====================================================================
 */
void cmArcfourCrypt(
        NQ_BYTE* data,
        NQ_UINT dataLen,
        const NQ_BYTE *key,
        NQ_UINT keyLen
        )
{
    NQ_BYTE sBox[258];
    NQ_BYTE idxI = 0, idxJ = 0, j = 0;
    NQ_UINT idx;

    for (idx = 0; idx < 256; idx++)
    {
        sBox[idx] = (NQ_BYTE)idx;
    }
    for (idx = 0; idx < 256; idx++)
    {
        NQ_BYTE tc;

        j = (NQ_BYTE)(j + sBox[idx] + key[idx % keyLen]);

        tc = sBox[idx];
        sBox[idx] = sBox[j];
        sBox[j] = tc;
    }
    sBox[257] = sBox[256] = 0;

    for (idx = 0; idx < dataLen; idx++)
    {
        NQ_BYTE tc;
        NQ_BYTE t;

        idxI = (NQ_BYTE)((idxI == 255) ? 0 : idxI + 1);
        idxJ = (NQ_BYTE)(idxJ + sBox[idxI]);
        tc = sBox[idxI];
        sBox[idxI] = sBox[idxJ];
        sBox[idxJ] = tc;
        t = (NQ_BYTE)(sBox[idxI] + sBox[idxJ]);
        data[idx] = data[idx] ^ sBox[t];
    }
    sBox[256] = idxI;
    sBox[257] = idxJ;
}

/*
 *====================================================================
 * PURPOSE: Prepare ARC4 state
 *--------------------------------------------------------------------
 * PARAMS:  IN key
 *          IN key length
 *          IN/OUT state of 255 bytes size
 *
 * RETURNS: none
 *
 * NOTES:   none
 *====================================================================
 */
void cmArcfourPrepareState(
        const NQ_BYTE *key,
        NQ_UINT keyLen,
        NQ_BYTE * state
        )
{
    NQ_UINT idx;
    NQ_BYTE j = 0;

    for (idx = 0; idx < 256; idx++)
    {
        state[idx] = (NQ_BYTE)idx;
    }
    for (idx = 0; idx < 256; idx++)
    {
        NQ_BYTE tc;

        j = (NQ_BYTE)(j + state[idx] + key[idx % keyLen]);

        tc = state[idx];
        state[idx] = state[j];
        state[j] = tc;
    }
}

/*
 *====================================================================
 * PURPOSE: Encrypt using ARC4 state
 *--------------------------------------------------------------------
 * PARAMS:  IN data
 *          IN data length
 *          IN/OUT state
 *
 * RETURNS: none
 *
 * NOTES:   none
 *====================================================================
 */
void cmArcfourCryptWithState(
        NQ_BYTE* data,
        NQ_UINT dataLen,
        NQ_BYTE * state
        )
{
    NQ_BYTE idxI = 0, idxJ = 0;
    NQ_UINT idx;

    idxI = state[256];
    idxJ = state[257];

    state[257] = state[256] = 0;
    for (idx = 0; idx < dataLen; idx++)
    {
        NQ_BYTE tc;
        NQ_BYTE t;

        idxI = (NQ_BYTE)((idxI == 255) ? 0 : idxI + 1);
        idxJ = (NQ_BYTE)(idxJ + state[idxI]);
        tc = state[idxI];
        state[idxI] = state[idxJ];
        state[idxJ] = tc;
        t = (NQ_BYTE)(state[idxI] + state[idxJ]);
        data[idx] = data[idx] ^ state[t];
    }
    state[256] = idxI;
    state[257] = idxJ;
}

