/*********************************************************************
 *
 *           Copyright (c) 2021 by Visuality Systems, Ltd.
 *
 *********************************************************************
 * FILE NAME     : $Workfile:$
 * ID            : $Header:$
 * REVISION      : $Revision:$
 *--------------------------------------------------------------------
 * DESCRIPTION   : Define used by AES, CMAC, GMC
 *--------------------------------------------------------------------
 * MODULE        : Auth - AM
 * DEPENDENCIES  : None
 ********************************************************************/

#ifndef _AMAES_H_
#define _AMAES_H_

#define NONCE_LEN 12        /* AES use 12 bytes of nonce, then extend to 16 bytes IV( initial vector ) */
#define AES_BLOCK_SIZE 16    /* AES block size is 16 bytes */
#define EXTKEY_LEN 44        /* AES-128 extends key to 44 bytes */

#define AES_128_CCM_M 16
#define AES_128_CCM_L 4
#define AES_128_CCM_M_tag (AES_128_CCM_M - 2) / 2
#define AES_128_CCM_L_tag (AES_128_CCM_L - 1)

#define AES_Get32(_a)     (((NQ_UINT32)(_a)[0] << 24) ^ ((NQ_UINT32)(_a)[1] << 16) ^ ((NQ_UINT32)(_a)[2] <<  8) ^ ((NQ_UINT32)(_a)[3]))
#define AES_Put32(buf, in) { (buf)[0] = (NQ_BYTE)((in) >> 24);\
                            (buf)[1] = (NQ_BYTE)((in) >> 16);\
                            (buf)[2] = (NQ_BYTE)((in) >>  8);\
                            (buf)[3] = (NQ_BYTE)(in); }


#define GET_BYTES_FROM32_BE(a) ((((NQ_UINT32) (a)[0]) << 24) | (((NQ_UINT32) (a)[1]) << 16) | \
                  (((NQ_UINT32) (a)[2]) << 8) | ((NQ_UINT32) (a)[3]))
#define PUT_BYTES_IN32_BE(a, val)                    \
         {                             \
             (a)[0] = (NQ_BYTE) ((((NQ_UINT32) (val)) >> 24));     \
             (a)[1] = (NQ_BYTE) ((((NQ_UINT32) (val)) >> 16));     \
             (a)[2] = (NQ_BYTE) ((((NQ_UINT32) (val)) >> 8));     \
             (a)[3] = (NQ_BYTE) (((NQ_UINT32) (val)) & 0xff);     \
         }

#define PUT_BE_BYTES_MUL8_IN64(a, val)    \
         {                                 \
             (a)[0] = (NQ_BYTE) (0);         \
             (a)[1] = (NQ_BYTE) (0);         \
             (a)[2] = (NQ_BYTE) (0);         \
             (a)[3] = (NQ_BYTE) (((NQ_UINT32) (val)) >> 29); \
             (a)[4] = (NQ_BYTE) (((NQ_UINT32) (val)) >> 21); \
             (a)[5] = (NQ_BYTE) (((NQ_UINT32) (val)) >> 13); \
             (a)[6] = (NQ_BYTE) (((NQ_UINT32) (val)) >> 5);  \
             (a)[7] = (NQ_BYTE) (((NQ_UINT32) (val) << 3) & 0xff);     \
         }

#endif /* #ifndef _AMAES_H_ */
