/*********************************************************************
 *
 *           Copyright (c) 2021 by Visuality Systems, Ltd.
 *
 *********************************************************************
 * FILE NAME     : $Workfile:$
 * ID            : $Header:$
 * REVISION      : $Revision:$
 *--------------------------------------------------------------------
 * DESCRIPTION   : LLMNR Resolver
 *--------------------------------------------------------------------
 * MODULE        : RD - Responder Daemon
 * DEPENDENCIES  :
 ********************************************************************/

#include "ndllmnr.h"

#if defined(UD_ND_INCLUDENBDAEMON) && defined(UD_NQ_USETRANSPORTIPV4) && defined(UD_NB_INCLUDELLMNRRESPONDER)

static SYSocketHandle   LLMNRSocket;

void ndLLMNRSetSocket(SYSocketHandle socket)
{
    LLMNRSocket = socket;
}

NQ_STATUS ndLLMNRProcessExternalMessage(NDAdapterInfo* adapter)
{
    CMBufferReader  reader;
    CMBufferWriter  writer;
    DnsHeader       headerIn, headerOut;
    NQ_INT          j;
    NQ_STATUS       result = NQ_FAIL;
    NQ_IOBufPos     inMsgPos;
    NQ_IOBufPos     outMsgPos;
    IOBUF_POSCONSTRUCTORINIT(inMsgPos);
    IOBUF_POSCONSTRUCTORINIT(outMsgPos);
    IOBUF_POSCONSTRUCTOR(inMsgPos, adapter->inMsg, adapter->inLen);

    LOGFB(CM_TRC_LEVEL_FUNC_TOOL, "adapter:%p", adapter);

    if (adapter->inLen <= sizeof(DnsHeader))
    {
        goto Exit;
    }

    syMemset(&headerOut, 0, sizeof(DnsHeader));
    cmBufferReaderInit(&reader, inMsgPos, adapter->inLen);
    cmBufferReaderSetByteOrder(&reader, FALSE);

    nsReadDnsHeader(&reader, &headerIn);

    if (0 != (headerIn.flags1 & DNS_QUERY_RESPONSE))
    {
        LOGERR(CM_TRC_LEVEL_ERROR, "not a valid request");
        goto Exit;
    }

    if (0 == headerIn.questions)
    {
        LOGERR(CM_TRC_LEVEL_ERROR, "no questions");
        goto Exit;
    }

    for (j = 0; j < headerIn.questions; j++)
    {
        NQ_CHAR         name[CM_NQ_HOSTNAMESIZE + 1];
        NQ_STATUS       res;
        NQ_UINT16       type;
        NQ_COUNT        queryLen;
        NQ_IOBufPos     queryPos = cmBufferReaderGetPosition(&reader);

        if (cmBufferReaderGetDataCount(&reader) >= cmBufferReaderGetTotalSize(&reader))
        {
            LOGERR(CM_TRC_LEVEL_ERROR, "request buffer overflow");
            goto Exit;
        }
        if (NQ_FAIL == nsDnsDecodeName(&reader, name))
        {
            LOGERR(CM_TRC_LEVEL_ERROR, "failed to decode name");
            goto Exit;
        }

        cmBufferReadUint16(&reader , &type);
        cmBufferReaderSkip(&reader , 2);

        IOBUF_POSCONSTRUCTOR(outMsgPos, adapter->outMsg, CM_NB_DATAGRAMBUFFERSIZE);

        if (NS_DNS_A == type)
        {
            if (CM_NB_NAMELEN > syStrlen(name))
            {
                NQ_CHAR NBname[CM_NQ_HOSTNAMESIZE];

                syStrncpy(NBname, name, sizeof(NBname) - 1);
                NBname[sizeof(NBname) - 1] = '\0';

                if (NULL != ndLLMNRNameLookup(NBname))
                {
                    NQ_IPADDRESS    ipAnswer;
                    NQ_STATUS       res;

                    syMemcpy(&headerOut , &headerIn , sizeof(DnsHeader));

                    CM_IPADDR_ASSIGN4(ipAnswer , adapter->ip);
                    headerOut.answers = 1;
                    headerOut.flags1 = DNS_QUERY_RESPONSE;
                    cmBufferWriterInit(&writer , outMsgPos, CM_NB_DATAGRAMBUFFERSIZE);
                    cmBufferWriterSetByteOrder(&writer , FALSE);

                    nsWriteDnsHeader(&writer , &headerOut);

                    queryLen = cmBufferReaderGetDataCount(&reader);
                    cmBufferReaderSetPosition(&reader , queryPos);
                    queryLen -= cmBufferReaderGetDataCount(&reader);
                    cmBufferWriteBytes(&writer, cmBufferReaderGetPositionBytePtr(&reader, queryLen) , queryLen);

                    nsDnsWriteAnswer(&writer , name, type , &CM_IPADDR_GET4(ipAnswer)  , sizeof(NQ_UINT32));

                    CM_IPADDR_ASSIGN4(ipAnswer , adapter->inIp);
                    res = sySendToSocket(LLMNRSocket,(NQ_BYTE*)adapter->outMsg,(NQ_UINT)cmBufferWriterGetDataCount(&writer),&ipAnswer,adapter->inPort);

                    result = (res != NQ_FAIL ? NQ_SUCCESS : NQ_FAIL);
                    goto Exit;

                }
            }
        }
        else if (NS_DNS_PTR == type)
        {
            NQ_IPADDRESS *  qIp = NULL;
            NQ_CHAR         nameP[CM_NQ_HOSTNAMESIZE];

            syStrncpy(nameP, name, sizeof(nameP) - 1);
            nameP[sizeof(nameP) - 1] = '\0';
            qIp = nsDnsParseReversedName(nameP ,CM_IPADDR_IPV4);

            if (NULL != qIp)
            {
                if (CM_IPADDR_EQUAL4(*qIp , adapter->ip))
                {
                    NQ_IPADDRESS    sendIp;

                    cmMemoryFree(qIp);
                    syMemcpy(&headerOut, &headerIn, sizeof(DnsHeader));

                    headerOut.answers = 1;
                    headerOut.flags1 = DNS_QUERY_RESPONSE;
                    cmBufferWriterInit(&writer, outMsgPos, CM_NB_DATAGRAMBUFFERSIZE);
                    cmBufferWriterSetByteOrder(&writer, FALSE);

                    nsWriteDnsHeader(&writer, &headerOut);

                    queryLen = cmBufferReaderGetDataCount(&reader);
                    cmBufferReaderSetPosition(&reader, queryPos);
                    queryLen -= cmBufferReaderGetDataCount(&reader);

                    cmBufferWriteBytes(&writer, cmBufferReaderGetPositionBytePtr(&reader, queryLen), queryLen);

                    nsDnsWriteAnswer(&writer, name, type, (void *)cmNetBiosGetHostNameZeroed(), (NQ_UINT16)syStrlen(cmNetBiosGetHostNameZeroed()));

                    CM_IPADDR_ASSIGN4(sendIp, adapter->inIp);
                    res = sySendToSocket(LLMNRSocket,(NQ_BYTE*)adapter->outMsg,(NQ_UINT)cmBufferWriterGetDataCount(&writer), &sendIp, adapter->inPort);
                    result = (res != NQ_FAIL ? NQ_SUCCESS : NQ_FAIL);
                    goto Exit;
                }

                cmMemoryFree(qIp);
            }
        }
    }

    result = NQ_SUCCESS;

Exit:
    LOGFE(CM_TRC_LEVEL_FUNC_TOOL, "result:0x%x", result);
    return result;
}

#endif /* defined(UD_ND_INCLUDENBDAEMON) && defined(UD_NQ_USETRANSPORTIPV4) && defined(UD_NB_INCLUDELLMNRRESPONDER) */
