/*************************************************************************
 * Copyright (c) 2021 by Visuality Systems, Ltd.
 *
 *                     All Rights Reserved
 *
 * This item is the property of Visuality Systems, Ltd., and contains
 * confidential, proprietary, and trade-secret information. It may not
 * be transferred from the custody or control of Visuality Systems, Ltd.,
 * except as expressly authorized in writing by an officer of Visuality
 * Systems, Ltd. Neither this item nor the information it contains may
 * be used, transferred, reproduced, published, or disclosed, in whole
 * or in part, and directly or indirectly, except as expressly authorized
 * by an officer of Visuality Systems, Ltd., pursuant to written agreement.
 *
 *************************************************************************
 * FILE NAME     : $Workfile:$
 * ID            : $Header:$
 * REVISION      : $Revision:$
 *--------------------------------------------------------------------
 * DESCRIPTION   : Client secure operations
 *--------------------------------------------------------------------
 * MODULE        : Client
 * DEPENDENCIES  :
 *************************************************************************/

#include "ccsecure.h"
#include "ccserver.h"
#include "ccshare.h"
#include "cmfinddc.h"
#include "amspnego.h"

#ifdef UD_NQ_INCLUDECIFSCLIENT

/* -- Static data -- */

static SYMutex guard;                           /* critical section guard */
static NQ_BOOL signingPolicy;                   /* indicates whether Client has "enabled signatures" */
static NQ_BOOL isModuleInitialized = FALSE;

/* -- API functions -- */

NQ_BOOL ccSecureStart(void)
{
   LOGFB(CM_TRC_LEVEL_FUNC_COMMON);

   if (isModuleInitialized)
   {
      goto Exit;
   }

   syMutexCreate(&guard);
   signingPolicy = TRUE;
   isModuleInitialized = TRUE;

Exit:
   LOGFE(CM_TRC_LEVEL_FUNC_COMMON);
   return TRUE;
}

void ccSecureShutdown(void)
{
   LOGFB(CM_TRC_LEVEL_FUNC_COMMON);

   if( isModuleInitialized )
   {
       syMutexDelete(&guard);
      isModuleInitialized = FALSE;
   }

   LOGFE(CM_TRC_LEVEL_FUNC_COMMON);
}

NQ_BOOL ccGetSigningPolicy(void)
{
    NQ_BOOL signing;

    syMutexTake(&guard);
    signing = signingPolicy;
    syMutexGive(&guard);

    return signing;
}

void ccSetSigningPolicy(NQ_BOOL enable)
{
    syMutexTake(&guard);
    signingPolicy = enable;
    syMutexGive(&guard);
}

NQ_STATUS ccSetMinSecurityLevel(NQ_INT level)
{
    return amSpnegoClientSetMinSecurityLevel(level);
}

NQ_INT ccGetMinSecurityLevel(void)
{
    return amSpnegoClientGetMinSecurityLevel();
}

NQ_STATUS ccSetMaxSecurityLevel(NQ_INT level)
{
    return amSpnegoClientSetMaxSecurityLevel(level);
}

NQ_INT ccGetMaxSecurityLevel(void)
{
    return amSpnegoClientGetMaxSecurityLevel();
}

#endif /* UD_NQ_INCLUDECIFSCLIENT */
