/*************************************************************************
 * Copyright (c) 2021 by Visuality Systems, Ltd.
 *
 *                     All Rights Reserved
 *
 * This item is the property of Visuality Systems, Ltd., and contains
 * confidential, proprietary, and trade-secret information. It may not
 * be transferred from the custody or control of Visuality Systems, Ltd.,
 * except as expressly authorized in writing by an officer of Visuality
 * Systems, Ltd. Neither this item nor the information it contains may
 * be used, transferred, reproduced, published, or disclosed, in whole
 * or in part, and directly or indirectly, except as expressly authorized
 * by an officer of Visuality Systems, Ltd., pursuant to written agreement.
 *
 *************************************************************************
 * FILE NAME     : $Workfile:$
 * ID            : $Header:$
 * REVISION      : $Revision:$
 *--------------------------------------------------------------------
 * DESCRIPTION   : Client info operations
 *--------------------------------------------------------------------
 * MODULE        : Client
 * DEPENDENCIES  :
 *************************************************************************/

#ifndef _CCINFO_H_
#define _CCINFO_H_

#include "cmapi.h"

/* Description
   This function is called to check for path existence.
   
   Parameters
   path :    File path.
   stripLast :   Whether to strip last path component.
   resolvedPath :  New path resolved through DFS.
   Returns
   This function returns TRUE if file path exists
   or FALSE otherwise. */
NQ_BOOL ccCheckPath(const NQ_WCHAR * path, NQ_BOOL stripLast, NQ_WCHAR **resolvedPath);

#endif  /* _CCINFO_H_ */

