/*************************************************************************
 * Copyright (c) 2021 by Visuality Systems, Ltd.
 *
 *                     All Rights Reserved
 *
 * This item is the property of Visuality Systems, Ltd., and contains
 * confidential, proprietary, and trade-secret information. It may not
 * be transferred from the custody or control of Visuality Systems, Ltd.,
 * except as expressly authorized in writing by an officer of Visuality
 * Systems, Ltd. Neither this item nor the information it contains may
 * be used, transferred, reproduced, published, or disclosed, in whole
 * or in part, and directly or indirectly, except as expressly authorized
 * by an officer of Visuality Systems, Ltd., pursuant to written agreement.
 *
 *************************************************************************
 * FILE NAME     : $Workfile:$
 * ID            : $Header:$
 * REVISION      : $Revision:$
 *--------------------------------------------------------------------
 * DESCRIPTION   : Client errors configuration
 *--------------------------------------------------------------------
 * MODULE        : Client
 * DEPENDENCIES  :
 *************************************************************************/

#ifndef _CCERRORS_H_
#define _CCERRORS_H_

#include "ccapi.h"
#include "cmapi.h"

/* -- API Functions */

/* Description
   Get NQ error by SMB NT status.
   Parameters
   status :  SMB/SMB2 NT status.
   isNt: TRUE for NT error
   Returns
   NQ error code.                 */
NQ_STATUS ccErrorsStatusToNq(NQ_UINT32 statusSmb, NQ_BOOL isNT);

/* Description
   Modify error mapping SMB to NQ.
   When reconnecting client, we map some SMB errors to be mapped to NQ error: "try again".
   When reconnect is done it will be mapped again as "normal" NQ codes.
   setForReconnect:  True = modify for reconnect. False - return value to normal value.
   Returns
   None.                 */
void ccErrorsModifyMapping(NQ_BOOL setForReconnect);

#endif /* _CCERRORS_H_   */
